/*
 * Decompiled with CFR 0.152.
 */
package crimsonfluff.crimsoncompass;

import crimsonfluff.crimsoncompass.DeathCapability;
import crimsonfluff.crimsoncompass.PlayerProperties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PropertiesDispatcher
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final LazyOptional<DeathCapability> deathCap = LazyOptional.of(DeathCapability::new);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return cap == PlayerProperties.PLAYER_DEATH ? this.deathCap.cast() : LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.deathCap.ifPresent(cap -> cap.saveNBTData(nbt));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.deathCap.ifPresent(cap -> cap.loadNBTData(nbt));
    }
}

