/*
 * Decompiled with CFR 0.152.
 */
package crimsonfluff.crimsoncompass;

import crimsonfluff.crimsoncompass.init.itemsInit;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CompassRender
implements IItemPropertyGetter {
    private double prevAngle = 0.0;
    private double prevWobble = 0.0;
    private long prevWorldTime = 0L;

    @SubscribeEvent
    public static void onItemModelsProperties(FMLClientSetupEvent event) {
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_BASTION_REMNANT.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_BURIED_TREASURE.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_DESERT_PYRAMID.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_END_CITY.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_FORTRESS.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_IGLOO.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_JUNGLE_PYRAMID.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_MINESHAFT.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_MONUMENT.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_NETHER_FOSSIL.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_OCEAN_RUIN.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_PILLAGER_OUTPOST.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_RUINED_PORTAL.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_SHIPWRECK.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_STRONGHOLD.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_SWAMP_HUT.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_VILLAGE.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_WOODLAND_MANSION.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_DEATH.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_WORLDSPAWN.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_BEDSPAWN.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
        ItemModelsProperties.func_239418_a_((Item)((Item)itemsInit.COMPASS_SLIME.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new CompassRender());
    }

    public float call(ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity livingEntity) {
        LivingEntity entity;
        boolean isLiving;
        boolean bl = isLiving = livingEntity != null;
        if (!isLiving && !stack.func_82839_y() || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("pos")) {
            return 0.0f;
        }
        Object object = entity = isLiving ? livingEntity : stack.func_82836_z();
        if (world == null) {
            world = (ClientWorld)entity.field_70170_p;
        }
        int[] blockPos = stack.func_77978_p().func_74759_k("pos");
        double entityAngle = isLiving ? (double)entity.func_70079_am() : this.getFrameAngle((ItemFrameEntity)entity);
        entityAngle /= 360.0;
        entityAngle = MathHelper.func_191273_b((double)entityAngle, (double)1.0);
        double posAngle = this.getPosToAngle(blockPos, (Entity)entity);
        double angle = 0.5 - (entityAngle - 0.25 - (posAngle /= Math.PI * 2));
        if (isLiving) {
            angle = this.wobble((World)world, angle);
        }
        return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
    }

    private double wobble(World world, double angle) {
        long worldTime = world.func_82737_E();
        if (worldTime != this.prevWorldTime) {
            this.prevWorldTime = worldTime;
            double angleDifference = angle - this.prevAngle;
            angleDifference = MathHelper.func_191273_b((double)(angleDifference + 0.5), (double)1.0) - 0.5;
            this.prevWobble += angleDifference * 0.1;
            this.prevWobble *= 0.8;
            this.prevAngle = MathHelper.func_191273_b((double)(this.prevAngle + this.prevWobble), (double)1.0);
        }
        return this.prevAngle;
    }

    private double getFrameAngle(ItemFrameEntity entity) {
        return MathHelper.func_188209_b((int)(180 + entity.func_174811_aO().func_96559_d() * 90));
    }

    private double getPosToAngle(int[] pos, Entity entity) {
        return Math.atan2((double)pos[2] - entity.func_226281_cx_(), (double)pos[0] - entity.func_226277_ct_());
    }
}

