/*
 * Decompiled with CFR 0.152.
 */
package crimsonfluff.crimsoncompass;

import crimsonfluff.crimsoncompass.ConfigBuilder;
import crimsonfluff.crimsoncompass.DeathCapability;
import crimsonfluff.crimsoncompass.PlayerProperties;
import crimsonfluff.crimsoncompass.PropertiesDispatcher;
import crimsonfluff.crimsoncompass.init.itemsInit;
import crimsonfluff.crimsoncompass.init.soundsInit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crimsoncompass")
public class CrimsonCompass {
    public static final String MOD_ID = "crimsoncompass";
    public static final Logger LOGGER = LogManager.getLogger((String)"crimsoncompass");
    public static final ConfigBuilder CONFIGURATION = new ConfigBuilder();
    public static final ItemGroup TAB = new ItemGroup("crimsoncompass"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)itemsInit.COMPASS_MONUMENT.get());
        }
    };

    public CrimsonCompass() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CrimsonCompass.CONFIGURATION.COMMON);
        soundsInit.SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        itemsInit.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        CrimsonCompass.registerCapabilities();
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity().field_70170_p instanceof ServerWorld && event.getEntity() instanceof PlayerEntity) {
            PlayerEntity playerIn = (PlayerEntity)event.getEntity();
            playerIn.getCapability(PlayerProperties.PLAYER_DEATH, null).ifPresent(cap -> cap.deathPosWrite(playerIn.func_233580_cy_()));
        }
    }

    private static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(DeathCapability.class, (Capability.IStorage)new Capability.IStorage<DeathCapability>(){

            public void readNBT(Capability<DeathCapability> capability, DeathCapability deathCapability, Direction direction, INBT inbt) {
                throw new UnsupportedOperationException();
            }

            public INBT writeNBT(Capability<DeathCapability> capability, DeathCapability deathCapability, Direction direction) {
                throw new UnsupportedOperationException();
            }
        }, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @SubscribeEvent
    public void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity && !((Entity)event.getObject()).getCapability(PlayerProperties.PLAYER_DEATH).isPresent()) {
            event.addCapability(new ResourceLocation(MOD_ID, ""), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            LazyOptional capability = event.getOriginal().getCapability(PlayerProperties.PLAYER_DEATH);
            capability.ifPresent(oldPlayer -> event.getPlayer().getCapability(PlayerProperties.PLAYER_DEATH).ifPresent(newPlayer -> {
                newPlayer.copyFrom((DeathCapability)oldPlayer);
                if (((Boolean)CrimsonCompass.CONFIGURATION.compassUponDeath.get()).booleanValue()) {
                    ItemStack COMPASS = new ItemStack((IItemProvider)itemsInit.COMPASS_DEATH.get());
                    COMPASS.func_196082_o().func_74783_a("pos", oldPlayer.deathPosRead());
                    event.getPlayer().func_191521_c(COMPASS);
                }
            }));
        }
    }

    public static float getDistance(double x1, double z1, double x2, double z2) {
        double i = x2 - x1;
        double j = z2 - z1;
        return MathHelper.func_76129_c((float)((float)(i * i + j * j)));
    }
}

