/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader;

import io.activej.serializer.BinarySerializer;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerBuilder;
import io.activej.serializer.stream.StreamInput;
import io.activej.serializer.stream.StreamOutput;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_390;
import net.minecraft.class_4536;
import net.minecraft.class_4724;
import net.minecraft.class_702;
import net.minecraft.class_815;
import net.quantumfusion.dashloader.DashException;
import net.quantumfusion.dashloader.DashRegistry;
import net.quantumfusion.dashloader.MappingData;
import net.quantumfusion.dashloader.api.DashLoaderAPI;
import net.quantumfusion.dashloader.atlas.DashSpriteAtlasData;
import net.quantumfusion.dashloader.atlas.DashSpriteAtlasTextureData;
import net.quantumfusion.dashloader.blockstates.DashBlockStateData;
import net.quantumfusion.dashloader.font.DashFontManagerData;
import net.quantumfusion.dashloader.misc.DashMetadata;
import net.quantumfusion.dashloader.misc.DashParticleData;
import net.quantumfusion.dashloader.misc.DashSplashTextData;
import net.quantumfusion.dashloader.mixin.AbstractTextureAccessor;
import net.quantumfusion.dashloader.mixin.SpriteAtlasTextureAccessor;
import net.quantumfusion.dashloader.models.DashModelData;
import net.quantumfusion.dashloader.registry.RegistryBlockStateData;
import net.quantumfusion.dashloader.registry.RegistryFontData;
import net.quantumfusion.dashloader.registry.RegistryIdentifierData;
import net.quantumfusion.dashloader.registry.RegistryImageData;
import net.quantumfusion.dashloader.registry.RegistryModelData;
import net.quantumfusion.dashloader.registry.RegistryPredicateData;
import net.quantumfusion.dashloader.registry.RegistryPropertyData;
import net.quantumfusion.dashloader.registry.RegistryPropertyValueData;
import net.quantumfusion.dashloader.registry.RegistrySpriteData;
import net.quantumfusion.dashloader.util.DashCachePaths;
import net.quantumfusion.dashloader.util.DashCacheState;
import net.quantumfusion.dashloader.util.ReloadEnum;
import net.quantumfusion.dashloader.util.ThreadHelper;
import net.quantumfusion.dashloader.util.TimeHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DashLoader {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final int totalTasks = 22;
    public static final double formatVersion = 2.0;
    public static final String version = ((ModContainer)FabricLoader.getInstance().getModContainer("dashloader").get()).getMetadata().getVersion().getFriendlyString();
    private static final Path config = FabricLoader.getInstance().getConfigDir().normalize();
    private static final boolean debug = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static ForkJoinPool THREADPOOL;
    public static String task;
    private static DashLoader instance;
    public final Map<class_1059, DashSpriteAtlasTextureData> atlasData = new HashMap<class_1059, DashSpriteAtlasTextureData>();
    public final Map<class_1095, Pair<List<class_815>, class_2689<class_2248, class_2680>>> multipartData = new HashMap<class_1095, Pair<List<class_815>, class_2689<class_2248, class_2680>>>();
    public final List<class_1059> atlasesToRegister;
    private final ClassLoader classLoader;
    private final List<class_1059> extraAtlases;
    private final ConcurrentHashMap<Class<?>, BinarySerializer> serializers = new ConcurrentHashMap();
    public int tasksComplete = 0;
    public DashCacheState state;
    public Map<class_2960, List<class_390>> fonts = new HashMap<class_2960, List<class_390>>();
    private DashLoaderAPI api;
    private Object2IntMap<class_2680> stateLookupOut;
    private MappingData mappings = new MappingData();
    private class_4724 atlasManager;
    private Object2IntMap<class_2680> stateLookup;
    private Map<class_2960, class_1087> models;
    private Map<class_2960, class_702.class_4090> particleSprites;
    private class_1059 particleAtlas;
    private List<String> splashText;

    public DashLoader(ClassLoader classLoader) {
        LOGGER.info("Creating DashLoader Instance");
        instance = this;
        this.classLoader = classLoader;
        this.extraAtlases = new ArrayList<class_1059>();
        this.atlasesToRegister = new ArrayList<class_1059>();
        this.api = new DashLoaderAPI();
        LOGGER.info("Created DashLoader with classloader: " + classLoader.getClass().getSimpleName());
    }

    public static Path getConfig() {
        return config;
    }

    public static DashLoader getInstance() {
        return instance;
    }

    public class_4724 getAtlasManagerOut() {
        return this.mappings.atlasManagerOut;
    }

    public Object2IntMap<class_2680> getStateLookupOut() {
        return this.stateLookupOut;
    }

    public Map<class_2960, class_1087> getModelsOut() {
        return this.mappings.modelsOut;
    }

    public Map<class_2960, List<class_1058>> getParticlesOut() {
        return this.mappings.particlesOut;
    }

    public Map<class_2960, List<class_390>> getFontsOut() {
        return this.mappings.fontsOut;
    }

    public List<String> getSplashTextOut() {
        return this.mappings.splashTextOut;
    }

    public void reload() {
        LOGGER.info("Starting DashLoader thread.");
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            LOGGER.warn("DashLoader launched in dev.");
        }
        this.state = DashCacheState.LOADING;
        Instant start = Instant.now();
        Thread dashLoaderThread = new Thread(() -> {
            ReloadEnum shouldReload;
            this.initThreadPool();
            this.api.initAPI();
            this.initSerializers();
            this.createDirectory();
            LOGGER.info("[4/4] Launching DashCache.");
            DashMetadata currentMetadata = DashMetadata.create();
            if (Arrays.stream(DashCachePaths.values()).allMatch(path -> path.getPath().toFile().exists())) {
                DashMetadata previousMetadata = this.deserialize(DashMetadata.class, DashCachePaths.DASH_METADATA.getPath(), "Metadata");
                shouldReload = currentMetadata.getState(previousMetadata);
            } else {
                shouldReload = ReloadEnum.MISSING_FILES;
            }
            if (shouldReload == ReloadEnum.ACCEPT) {
                this.loadDashCache();
            } else {
                switch (shouldReload) {
                    case FORMAT_CHANGE: {
                        LOGGER.warn("DashLoader update changed format. Recache requested.");
                        break;
                    }
                    case MOD_CHANGE: {
                        LOGGER.warn("DashLoader detected mod change. Recache requested.");
                        break;
                    }
                    case MISSING_FILES: {
                        LOGGER.warn("DashLoader detected missing files. Recache requested.");
                    }
                }
                this.destroyCache();
                this.createMetadata(currentMetadata);
                this.state = DashCacheState.EMPTY;
            }
            this.shutdownThreadPool();
            LOGGER.info("Loaded cache in " + TimeHelper.getDecimalS(start, Instant.now()) + "s");
        });
        dashLoaderThread.setContextClassLoader(this.classLoader);
        dashLoaderThread.setName("dashloader-supervisor");
        dashLoaderThread.start();
    }

    public DashLoaderAPI getApi() {
        return this.api;
    }

    private void shutdownThreadPool() {
        THREADPOOL.shutdown();
    }

    private void createMetadata(DashMetadata data) {
        --this.tasksComplete;
        this.serializeObject(data, DashCachePaths.DASH_METADATA.getPath(), "Mod Info");
    }

    private void createDirectory() {
        this.prepareAccess(new File(String.valueOf(config.resolve("quantumfusion/dashloader")))).mkdirs();
    }

    public void addExtraAtlasAssets(class_1059 atlas) {
        this.extraAtlases.add(atlas);
    }

    public void addBakedModelAssets(class_4724 atlasManager, Object2IntMap<class_2680> stateLookup, Map<class_2960, class_1087> models) {
        this.atlasManager = atlasManager;
        this.models = models;
        this.stateLookup = stateLookup;
    }

    public void addParticleManagerAssets(Map<class_2960, class_702.class_4090> particles, class_1059 atlas) {
        this.particleSprites = particles;
        this.particleAtlas = atlas;
    }

    public void addSplashTextAssets(List<String> splashText) {
        this.splashText = splashText;
    }

    public void saveDashCache() {
        Instant start = Instant.now();
        this.initThreadPool();
        this.api.initAPI();
        this.initSerializers();
        this.createDirectory();
        ++this.tasksComplete;
        DashRegistry registry = new DashRegistry(this);
        MappingData mappings = new MappingData();
        this.logAndTask("Mapping Blockstates");
        mappings.setBlockStateData(new DashBlockStateData(this.stateLookup, registry));
        this.logAndTask("Mapping Models");
        mappings.setModelData(new DashModelData(this.models, this.multipartData, registry));
        this.logAndTask("Mapping Particles");
        mappings.setParticleData(new DashParticleData(this.particleSprites, this.particleAtlas, registry));
        this.logAndTask("Mapping Fonts");
        mappings.setFontManagerData(new DashFontManagerData(this.fonts, registry));
        this.logAndTask("Mapping Splash Text");
        mappings.setSplashTextData(new DashSplashTextData(this.splashText));
        this.logAndTask("Mapping Atlas");
        mappings.setSpriteAtlasData(new DashSpriteAtlasData(this.atlasManager, this.atlasData, registry, this.extraAtlases));
        this.serializeObject(mappings.modelData, DashCachePaths.MODELS.getPath(), "Models");
        this.serializeObject(mappings.spriteAtlasData, DashCachePaths.SPRITEATLAS.getPath(), "Atlases");
        this.serializeObject(mappings.blockStateData, DashCachePaths.BLOCKSTATE.getPath(), "Blockstates");
        this.serializeObject(mappings.particleData, DashCachePaths.PARTICLE.getPath(), "Particles");
        this.serializeObject(mappings.fontManagerData, DashCachePaths.FONT.getPath(), "Fonts");
        this.serializeObject(mappings.splashTextData, DashCachePaths.SPLASH.getPath(), "Splash Text");
        this.serializeObject(registry.getBlockstates(), DashCachePaths.REGISTRY_BLOCKSTATE.getPath(), "Registry Blockstates");
        this.serializeObject(registry.getFonts(), DashCachePaths.REGISTRY_FONT.getPath(), "Registry Fonts");
        this.serializeObject(registry.getIdentifiers(), DashCachePaths.REGISTRY_IDENTIFIER.getPath(), "Registry Identifiers");
        this.serializeObject(registry.getImages(), DashCachePaths.REGISTRY_IMAGE.getPath(), "Registry Images");
        this.serializeObject(registry.getModels(), DashCachePaths.REGISTRY_MODEL.getPath(), "Registry Models");
        this.serializeObject(registry.getPredicates(), DashCachePaths.REGISTRY_PREDICATE.getPath(), "Registry Predicates");
        this.serializeObject(registry.getProperties(), DashCachePaths.REGISTRY_PROPERTY.getPath(), "Registry Properties");
        this.serializeObject(registry.getPropertyValues(), DashCachePaths.REGISTRY_PROPERTYVALUE.getPath(), "Registry PropertyValues");
        this.serializeObject(registry.getSprites(), DashCachePaths.REGISTRY_SPRITE.getPath(), "Registry Sprites");
        registry.apiReport(LOGGER);
        this.shutdownThreadPool();
        task = "Caching is now complete.";
        LOGGER.info("Created cache in " + TimeHelper.getDecimalS(start, Instant.now()) + "s");
    }

    private void initThreadPool() {
        THREADPOOL = new ForkJoinPool(Runtime.getRuntime().availableProcessors() + 2, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setName("dashloader-thread-" + worker.getPoolIndex());
            worker.setContextClassLoader(this.classLoader);
            return worker;
        }, null, true);
    }

    public void loadDashCache() {
        LOGGER.info("Starting DashLoader Deserialization");
        try {
            DashRegistry registry = new DashRegistry(this);
            ThreadHelper.exec(() -> registry.setBlockstates(this.deserialize(RegistryBlockStateData.class, (Path)DashCachePaths.REGISTRY_BLOCKSTATE.getPath(), (String)"Registry Blockstates").blockstates), () -> registry.setFonts(this.deserialize(RegistryFontData.class, (Path)DashCachePaths.REGISTRY_FONT.getPath(), (String)"Registry Fonts").fonts), () -> registry.setIdentifiers(this.deserialize(RegistryIdentifierData.class, (Path)DashCachePaths.REGISTRY_IDENTIFIER.getPath(), (String)"Registry Identifiers").identifiers), () -> registry.setImages(this.deserialize(RegistryImageData.class, (Path)DashCachePaths.REGISTRY_IMAGE.getPath(), (String)"Registry Images").images), () -> registry.setModels(this.deserialize(RegistryModelData.class, DashCachePaths.REGISTRY_MODEL.getPath(), "Registry Models")), () -> registry.setPredicates(this.deserialize(RegistryPredicateData.class, (Path)DashCachePaths.REGISTRY_PREDICATE.getPath(), (String)"Registry Predicates").predicates), () -> registry.setProperties(this.deserialize(RegistryPropertyData.class, (Path)DashCachePaths.REGISTRY_PROPERTY.getPath(), (String)"Registry Properties").property), () -> registry.setPropertyValues(this.deserialize(RegistryPropertyValueData.class, (Path)DashCachePaths.REGISTRY_PROPERTYVALUE.getPath(), (String)"Registry PropertyValues").propertyValues), () -> registry.setSprites(this.deserialize(RegistrySpriteData.class, (Path)DashCachePaths.REGISTRY_SPRITE.getPath(), (String)"Registry Sprites").sprites));
            LOGGER.info("      Loading Registry");
            registry.toUndash();
            this.mappings = new MappingData();
            ThreadHelper.exec(() -> this.mappings.setModelData(this.deserialize(DashModelData.class, DashCachePaths.MODELS.getPath(), "Models")), () -> this.mappings.setSpriteAtlasData(this.deserialize(DashSpriteAtlasData.class, DashCachePaths.SPRITEATLAS.getPath(), "Atlases")), () -> this.mappings.setBlockStateData(this.deserialize(DashBlockStateData.class, DashCachePaths.BLOCKSTATE.getPath(), "Blockstates")), () -> this.mappings.setParticleData(this.deserialize(DashParticleData.class, DashCachePaths.PARTICLE.getPath(), "Particles")), () -> this.mappings.setFontManagerData(this.deserialize(DashFontManagerData.class, DashCachePaths.FONT.getPath(), "Fonts")), () -> this.mappings.setSplashTextData(this.deserialize(DashSplashTextData.class, DashCachePaths.SPLASH.getPath(), "Splash Text")));
            LOGGER.info("      Loading Mappings");
            this.atlasesToRegister.addAll(this.mappings.toUndash(registry));
            LOGGER.info("    Loaded DashLoader");
            this.stateLookupOut = this.mappings.stateLookupOut;
            this.state = DashCacheState.LOADED;
        }
        catch (Exception e) {
            this.destroyCache(e);
            this.state = DashCacheState.CRASHLOADER;
        }
    }

    public void applyDashCache(class_1060 textureManager) {
        this.atlasesToRegister.forEach(spriteAtlasTexture -> {
            DashSpriteAtlasTextureData data = this.atlasData.get(spriteAtlasTexture);
            class_2960 id = spriteAtlasTexture.method_24106();
            int glId = class_4536.method_24956();
            int width = data.width;
            int maxLevel = data.maxLevel;
            int height = data.height;
            class_4536.method_24959((int)glId, (int)maxLevel, (int)width, (int)height);
            ((AbstractTextureAccessor)spriteAtlasTexture).setGlId(glId);
            ((SpriteAtlasTextureAccessor)spriteAtlasTexture).getSprites().forEach((identifier1, sprite) -> sprite.method_4584());
            textureManager.method_4616(id, (class_1044)spriteAtlasTexture);
            LOGGER.info("Allocated: {}x{}x{} {}-atlas", (Object)width, (Object)height, (Object)maxLevel, (Object)id);
        });
    }

    @NotNull
    private <T> T deserialize(Class<T> clazz, Path path, String name) {
        try {
            BinarySerializer serializer = this.serializers.get(clazz);
            if (serializer == null) {
                throw new DashException(name + " Serializer not found.");
            }
            Object out = StreamInput.create((InputStream)Files.newInputStream(path, new OpenOption[0])).deserialize(serializer);
            if (out == null) {
                throw new DashException(name + " Deserialization failed");
            }
            return (T)out;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DashException(name + " File failed");
        }
    }

    private <T> void serializeObject(T clazz, Path path, String name) {
        try {
            task = "Serializing " + name;
            LOGGER.info("  Starting " + name + " Serialization.");
            StreamOutput output = StreamOutput.create((OutputStream)Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE));
            output.serialize(this.serializers.get(clazz.getClass()), clazz);
            output.close();
            LOGGER.info("    Finished " + name + " Serialization.");
        }
        catch (IOException e) {
            LOGGER.fatal("Serializers: " + this.serializers.size());
            this.serializers.forEach((aClass, binarySerializer) -> LOGGER.fatal("Class: " + aClass + " Serializer: " + binarySerializer));
            e.printStackTrace();
        }
        ++this.tasksComplete;
    }

    public void destroyCache(Exception exception) {
        if (!debug) {
            LOGGER.error("DashLoader failed, destroying cache and requesting recache. Slow start predicted.");
            exception.printStackTrace();
            if (!Arrays.stream(DashCachePaths.values()).allMatch(path -> !path.getPath().toFile().exists() || path.getPath().toFile().delete())) {
                LOGGER.fatal("DashLoader file removal failed. Something went terribly wrong ");
            }
        } else {
            exception.printStackTrace();
        }
    }

    public void destroyCache() {
        if (!debug) {
            LOGGER.error("DashLoader failed, destroying cache and requesting recache. Slow start predicted.");
            if (!Arrays.stream(DashCachePaths.values()).allMatch(path -> !path.getPath().toFile().exists() || path.getPath().toFile().delete())) {
                LOGGER.fatal("DashLoader file removal failed. Something went terribly wrong ");
            }
        }
    }

    private void logAndTask(String s) {
        LOGGER.info(s);
        ++this.tasksComplete;
        task = s;
    }

    private File prepareAccess(File file) {
        if (!file.canWrite()) {
            file.setWritable(true);
        }
        if (!file.canRead()) {
            file.setReadable(true);
        }
        return file;
    }

    private void initSerializers() {
        LOGGER.info("[3/4]  Started Serializer init.");
        Instant start = Instant.now();
        Class[] classes = new Class[]{DashMetadata.class, DashModelData.class, DashSpriteAtlasData.class, DashBlockStateData.class, DashParticleData.class, DashFontManagerData.class, DashSplashTextData.class, RegistryBlockStateData.class, RegistryIdentifierData.class, RegistryImageData.class, RegistryFontData.class, RegistryModelData.class, RegistryPredicateData.class, RegistryPropertyData.class, RegistryPropertyValueData.class, RegistrySpriteData.class};
        Runnable[] runnables = new Runnable[]{() -> this.addSerializer(classes[0], SerializerBuilder.create()), () -> this.addSerializer(classes[1], SerializerBuilder.create()), () -> this.addSerializer(classes[2], SerializerBuilder.create()), () -> this.addSerializer(classes[3], SerializerBuilder.create()), () -> this.addSerializer(classes[4], SerializerBuilder.create()), () -> this.addSerializer(classes[5], SerializerBuilder.create()), () -> this.addSerializer(classes[6], SerializerBuilder.create()), () -> this.addSerializer(classes[7], SerializerBuilder.create()), () -> this.addSerializer(classes[8], SerializerBuilder.create()), () -> this.addSerializer(classes[9], SerializerBuilder.create()), () -> this.addSerializer(classes[10], SerializerBuilder.create().withSubclasses("fonts", this.api.fontTypes)), () -> this.addSerializer(classes[11], SerializerBuilder.create().withSubclasses("models", this.api.modelTypes)), () -> this.addSerializer(classes[12], SerializerBuilder.create().withSubclasses("predicates", this.api.predicateTypes)), () -> this.addSerializer(classes[13], SerializerBuilder.create().withSubclasses("properties", this.api.propertyTypes)), () -> this.addSerializer(classes[14], SerializerBuilder.create().withSubclasses("values", this.api.propertyValueTypes)), () -> this.addSerializer(classes[15], SerializerBuilder.create())};
        ThreadHelper.exec(runnables);
        LOGGER.info("[3/4] [" + Duration.between(start, Instant.now()).toMillis() + "ms] Created Serializers.");
    }

    private void addSerializer(Class<?> clazz, SerializerBuilder builder) {
        this.serializers.put(clazz, builder.withCompatibilityLevel(CompatibilityLevel.LEVEL_3_LE).build(clazz));
    }

    static {
        task = "Starting DashLoader";
    }
}

