/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_390;
import net.minecraft.class_815;
import net.quantumfusion.dashloader.DashLoader;
import net.quantumfusion.dashloader.api.Factory;
import net.quantumfusion.dashloader.api.FactoryType;
import net.quantumfusion.dashloader.api.predicates.PredicateFactory;
import net.quantumfusion.dashloader.api.properties.PropertyFactory;
import net.quantumfusion.dashloader.atlas.DashImage;
import net.quantumfusion.dashloader.atlas.DashSprite;
import net.quantumfusion.dashloader.blockstates.DashBlockState;
import net.quantumfusion.dashloader.blockstates.properties.DashProperty;
import net.quantumfusion.dashloader.blockstates.properties.value.DashPropertyValue;
import net.quantumfusion.dashloader.common.DashID;
import net.quantumfusion.dashloader.common.DashIdentifier;
import net.quantumfusion.dashloader.font.fonts.DashFont;
import net.quantumfusion.dashloader.mixin.NativeImageAccessor;
import net.quantumfusion.dashloader.models.DashModel;
import net.quantumfusion.dashloader.models.DashModelIdentifier;
import net.quantumfusion.dashloader.models.predicates.DashPredicate;
import net.quantumfusion.dashloader.models.predicates.DashStaticPredicate;
import net.quantumfusion.dashloader.registry.RegistryBlockStateData;
import net.quantumfusion.dashloader.registry.RegistryFontData;
import net.quantumfusion.dashloader.registry.RegistryIdentifierData;
import net.quantumfusion.dashloader.registry.RegistryImageData;
import net.quantumfusion.dashloader.registry.RegistryModelData;
import net.quantumfusion.dashloader.registry.RegistryPredicateData;
import net.quantumfusion.dashloader.registry.RegistryPropertyData;
import net.quantumfusion.dashloader.registry.RegistryPropertyValueData;
import net.quantumfusion.dashloader.registry.RegistrySpriteData;
import net.quantumfusion.dashloader.util.ThreadHelper;
import net.quantumfusion.dashloader.util.UndashTask;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DashRegistry {
    private static int totalTasks = 6;
    private static int tasksDone = 0;
    private final Map<Long, DashModel> models;
    public Map<Class, FactoryType> apiFailed = new ConcurrentHashMap<Class, FactoryType>();
    public Map<Long, class_2680> blockstatesOut;
    public Map<Long, Predicate<class_2680>> predicateOut;
    public Map<Long, class_2960> identifiersOut;
    public Map<Long, class_1087> modelsOut;
    public Map<Long, class_1058> spritesOut;
    public Map<Long, class_390> fontsOut;
    public Map<Long, class_1011> imagesOut;
    public Map<Long, class_2769<?>> propertiesOut;
    public Map<Long, Comparable<?>> propertyValuesOut;
    DashLoader loader;
    private Map<Long, DashBlockState> blockstates;
    private Map<Long, DashSprite> sprites;
    private Map<Long, DashID> identifiers;
    private Map<Long, DashFont> fonts;
    private Map<Long, DashImage> images;
    private Map<Long, DashPredicate> predicates;
    private Map<Long, DashProperty> properties;
    private Map<Long, DashPropertyValue> propertyValues;
    private List<Map<Long, DashModel>> modelsToDeserialize;

    public DashRegistry(Map<Long, DashBlockState> blockstates, Map<Long, DashSprite> sprites, Map<Long, DashID> identifiers, Map<Long, DashModel> models, Map<Long, DashFont> fonts, Map<Long, DashImage> images, Map<Long, DashPredicate> predicates, Map<Long, DashProperty> properties, Map<Long, DashPropertyValue> propertyValues) {
        this.blockstates = blockstates;
        this.sprites = sprites;
        this.identifiers = identifiers;
        this.models = models;
        this.fonts = fonts;
        this.images = images;
        this.predicates = predicates;
        this.properties = properties;
        this.propertyValues = propertyValues;
    }

    public DashRegistry(DashLoader loader) {
        this.blockstates = new HashMap<Long, DashBlockState>();
        this.sprites = new HashMap<Long, DashSprite>();
        this.identifiers = new HashMap<Long, DashID>();
        this.models = new HashMap<Long, DashModel>();
        this.fonts = new HashMap<Long, DashFont>();
        this.predicates = new HashMap<Long, DashPredicate>();
        this.images = new HashMap<Long, DashImage>();
        this.properties = new HashMap<Long, DashProperty>();
        this.propertyValues = new HashMap<Long, DashPropertyValue>();
        this.modelsToDeserialize = new ArrayList<Map<Long, DashModel>>();
        this.loader = loader;
    }

    public RegistryBlockStateData getBlockstates() {
        return new RegistryBlockStateData(this.blockstates);
    }

    public void setBlockstates(Map<Long, DashBlockState> blockstates) {
        this.blockstates = blockstates;
    }

    public RegistrySpriteData getSprites() {
        return new RegistrySpriteData(this.sprites);
    }

    public void setSprites(Map<Long, DashSprite> sprites) {
        this.sprites = sprites;
    }

    public RegistryIdentifierData getIdentifiers() {
        return new RegistryIdentifierData(this.identifiers);
    }

    public void setIdentifiers(Map<Long, DashID> identifiers) {
        this.identifiers = identifiers;
    }

    public RegistryModelData getModels() {
        HashMap<Integer, Map> modelsToAdd = new HashMap<Integer, Map>();
        this.models.forEach((aLong, dashModel) -> {
            Map longDashModelMap = (Map)modelsToAdd.get(dashModel.getStage());
            if (longDashModelMap == null) {
                HashMap<Long, DashModel> element = new HashMap<Long, DashModel>();
                element.put((Long)aLong, (DashModel)dashModel);
                modelsToAdd.put(dashModel.getStage(), element);
            } else {
                longDashModelMap.put(aLong, dashModel);
            }
        });
        this.modelsToDeserialize = new ArrayList<Map<Long, DashModel>>();
        modelsToAdd.forEach(this.modelsToDeserialize::add);
        return new RegistryModelData(this.modelsToDeserialize);
    }

    public void setModels(RegistryModelData data) {
        this.modelsToDeserialize = data.models;
    }

    public RegistryFontData getFonts() {
        return new RegistryFontData(this.fonts);
    }

    public void setFonts(Map<Long, DashFont> fonts) {
        this.fonts = fonts;
    }

    public RegistryImageData getImages() {
        return new RegistryImageData(this.images);
    }

    public void setImages(Map<Long, DashImage> images) {
        this.images = images;
    }

    public RegistryPredicateData getPredicates() {
        return new RegistryPredicateData(this.predicates);
    }

    public void setPredicates(Map<Long, DashPredicate> predicates) {
        this.predicates = predicates;
    }

    public RegistryPropertyData getProperties() {
        return new RegistryPropertyData(this.properties);
    }

    public void setProperties(Map<Long, DashProperty> properties) {
        this.properties = properties;
    }

    public RegistryPropertyValueData getPropertyValues() {
        return new RegistryPropertyValueData(this.propertyValues);
    }

    public void setPropertyValues(Map<Long, DashPropertyValue> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public long createBlockStatePointer(class_2680 blockState) {
        long hash = blockState.hashCode();
        if (this.blockstates.get(hash) == null) {
            this.blockstates.put(hash, new DashBlockState(blockState, this));
        }
        return hash;
    }

    public final <K> Long createModelPointer(class_1087 bakedModel, @Nullable K var) {
        if (bakedModel == null) {
            return null;
        }
        long hash = bakedModel.hashCode();
        if (this.models.get(hash) == null) {
            Factory model = this.loader.getApi().modelMappings.get(bakedModel.getClass());
            if (model != null) {
                this.models.put(hash, (DashModel)model.toDash(bakedModel, this, var));
            } else {
                this.apiFailed.putIfAbsent(bakedModel.getClass(), FactoryType.MODEL);
            }
        }
        return hash;
    }

    public final long createSpritePointer(class_1058 sprite) {
        long hash = sprite.hashCode();
        if (this.sprites.get(hash) == null) {
            this.sprites.put(hash, new DashSprite(sprite, this));
        }
        return hash;
    }

    public final long createIdentifierPointer(class_2960 identifier) {
        long hash = identifier.hashCode();
        if (this.identifiers.get(hash) == null) {
            if (identifier instanceof class_1091) {
                this.identifiers.put(hash, new DashModelIdentifier((class_1091)identifier));
            } else {
                this.identifiers.put(hash, new DashIdentifier(identifier));
            }
        }
        return hash;
    }

    public final long createImagePointer(class_1011 image) {
        long hash = ((NativeImageAccessor)image).getPointer();
        if (this.images.get(hash) == null) {
            this.images.put(hash, new DashImage(image));
        }
        return hash;
    }

    public final long createPredicatePointer(class_815 selector, class_2689<class_2248, class_2680> stateManager) {
        long hash = selector.hashCode();
        if (this.predicates.get(hash) == null) {
            this.predicates.put(hash, this.obtainPredicate(selector, stateManager));
        }
        return hash;
    }

    public final DashPredicate obtainPredicate(class_815 selector, class_2689<class_2248, class_2680> stateManager) {
        boolean isTrue;
        boolean bl = isTrue = selector == class_815.field_16900;
        if (selector == class_815.field_16901 || isTrue) {
            return new DashStaticPredicate(isTrue);
        }
        PredicateFactory predicateFactory = this.loader.getApi().predicateMappings.get(selector.getClass());
        if (predicateFactory != null) {
            return (DashPredicate)predicateFactory.toDash(selector, this, stateManager);
        }
        this.apiFailed.putIfAbsent(selector.getClass(), FactoryType.PREDICATE);
        return null;
    }

    public final long createFontPointer(class_390 font) {
        long hash = font.hashCode();
        if (this.fonts.get(hash) == null) {
            Factory fontFactory = this.loader.getApi().fontMappings.get(font.getClass());
            if (fontFactory != null) {
                this.fonts.put(hash, (DashFont)fontFactory.toDash(font, this, null));
            } else {
                this.apiFailed.putIfAbsent(font.getClass(), FactoryType.FONT);
            }
        }
        return hash;
    }

    public final Pair<Long, Long> createPropertyPointer(class_2769<?> property, Comparable<?> value) {
        boolean prop;
        long hashV = value.hashCode();
        long hashP = property.hashCode();
        boolean propVal = !this.propertyValues.containsKey(hashV);
        boolean bl = prop = !this.properties.containsKey(hashP);
        if (propVal || prop) {
            PropertyFactory propertyFactory = this.loader.getApi().propertyMappings.get(property.getClass());
            if (propertyFactory != null) {
                if (propVal) {
                    this.propertyValues.put(hashV, propertyFactory.toDash(value, this, Long.valueOf(hashP)));
                }
                if (prop) {
                    this.properties.put(hashP, propertyFactory.toDash((class_2769)property, this, hashP));
                }
            } else {
                this.apiFailed.put(property.getClass(), FactoryType.PROPERTY);
            }
        }
        return Pair.of((Object)hashP, (Object)hashV);
    }

    public final class_2680 getBlockstate(Long pointer) {
        class_2680 blockstate = this.blockstatesOut.get(pointer);
        if (blockstate == null) {
            DashLoader.LOGGER.error("Blockstate not found in data. PINTR: " + pointer);
        }
        return blockstate;
    }

    public final class_1058 getSprite(Long pointer) {
        class_1058 sprite = this.spritesOut.get(pointer);
        if (sprite == null) {
            DashLoader.LOGGER.error("Sprite not found in data. PINTR: " + pointer);
        }
        return sprite;
    }

    public final class_2960 getIdentifier(Long pointer) {
        class_2960 identifier = this.identifiersOut.get(pointer);
        if (identifier == null) {
            DashLoader.LOGGER.error("Identifier not found in data. PINTR: " + pointer);
        }
        return identifier;
    }

    public final class_1087 getModel(Long pointer) {
        class_1087 bakedModel = this.modelsOut.get(pointer);
        if (bakedModel == null) {
            DashLoader.LOGGER.error("Model not found in data. PINTR: " + pointer);
        }
        return bakedModel;
    }

    public final class_390 getFont(Long pointer) {
        class_390 font = this.fontsOut.get(pointer);
        if (font == null) {
            DashLoader.LOGGER.error("Font not found in data. PINTR: " + pointer);
        }
        return font;
    }

    public final class_1011 getImage(Long pointer) {
        class_1011 image = this.imagesOut.get(pointer);
        if (image == null) {
            DashLoader.LOGGER.error("NativeImage not found in data. PINTR: " + pointer);
        }
        return image;
    }

    public final Predicate<class_2680> getPredicate(Long pointer) {
        Predicate<class_2680> predicate = this.predicateOut.get(pointer);
        if (predicate == null) {
            DashLoader.LOGGER.error("Predicate not found in data. PINTR: " + pointer);
        }
        return predicate;
    }

    public final Pair<class_2769<?>, Comparable<?>> getProperty(Long propertyPointer, Long valuePointer) {
        class_2769<?> property = this.propertiesOut.get(propertyPointer);
        Comparable<?> value = this.propertyValuesOut.get(valuePointer);
        if (property == null || value == null) {
            DashLoader.LOGGER.error("Property not found in data. PINTR: " + propertyPointer + "/" + valuePointer);
        }
        return Pair.of(property, value);
    }

    public void toUndash() {
        Logger logger = LogManager.getLogger();
        totalTasks = 4 + this.modelsToDeserialize.size();
        this.log(logger, "Loading Simple Objects");
        this.identifiersOut = ThreadHelper.execParallel(this.identifiers, this);
        this.imagesOut = ThreadHelper.execParallel(this.images, this);
        this.identifiers = null;
        this.images = null;
        this.log(logger, "Loading Properties");
        this.propertiesOut = ThreadHelper.execParallel(this.properties, this);
        this.propertyValuesOut = ThreadHelper.execParallel(this.propertyValues, this);
        this.properties = null;
        this.propertyValues = null;
        this.log(logger, "Loading Advanced Objects");
        this.blockstatesOut = ThreadHelper.execParallel(this.blockstates, this);
        this.predicateOut = ThreadHelper.execParallel(this.predicates, this);
        this.spritesOut = ThreadHelper.execParallel(this.sprites, this);
        this.fontsOut = ThreadHelper.execParallel(this.fonts, this);
        this.blockstates = null;
        this.predicates = null;
        this.sprites = null;
        this.fonts = null;
        this.modelsOut = new ConcurrentHashMap<Long, class_1087>(this.models.size());
        short[] currentStage = new short[]{0};
        this.modelsToDeserialize.forEach(modelCategory -> {
            this.log(logger, "Loading " + modelCategory.size() + " Models: [" + currentStage[0] + "]");
            this.modelsOut.putAll(ThreadHelper.execParallel(modelCategory, this));
            currentStage[0] = (short)(currentStage[0] + 1);
        });
        this.log(logger, "Applying Model Overrides");
        this.modelsToDeserialize.forEach(modelcategory -> DashLoader.THREADPOOL.invoke(new UndashTask.ApplyTask(new ArrayList<DashModel>(modelcategory.values()), 100, this)));
        this.modelsToDeserialize = null;
    }

    private void log(Logger logger, String s) {
        logger.info("[" + ++tasksDone + "/" + totalTasks + "] " + s);
    }

    public void apiReport(Logger logger) {
        if (this.apiFailed.size() != 0) {
            logger.error("Found incompatible objects that were not able to be serialized.");
            int[] ints = new int[1];
            this.apiFailed.entrySet().stream().sorted(Comparator.comparing(e -> ((FactoryType)((Object)((Object)e.getValue()))).name)).forEach(entry -> {
                ints[0] = ints[0] + 1;
                logger.error("[" + ((FactoryType)((Object)((Object)entry.getValue()))).name() + "] Object: " + ((Class)entry.getKey()).getName());
            });
            logger.error("In total there are " + ints[0] + " incompatible objects. Please contact the mod developers to add support.");
        }
    }
}

