/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.api;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.gudenau.lib.unsafe.Unsafe;
import net.minecraft.class_1087;
import net.minecraft.class_2769;
import net.minecraft.class_390;
import net.minecraft.class_815;
import net.quantumfusion.dashloader.api.Factory;
import net.quantumfusion.dashloader.api.fonts.BitmapFontFactory;
import net.quantumfusion.dashloader.api.fonts.BlankFontFactory;
import net.quantumfusion.dashloader.api.fonts.FontFactory;
import net.quantumfusion.dashloader.api.fonts.UnicodeFontFactory;
import net.quantumfusion.dashloader.api.models.BasicBakedModelFactory;
import net.quantumfusion.dashloader.api.models.BuiltInBakedModelFactory;
import net.quantumfusion.dashloader.api.models.ModelFactory;
import net.quantumfusion.dashloader.api.models.MultipartBakedModelFactory;
import net.quantumfusion.dashloader.api.models.WeightedBakedModelFactory;
import net.quantumfusion.dashloader.api.predicates.AndPredicateFactory;
import net.quantumfusion.dashloader.api.predicates.OrPredicateFactory;
import net.quantumfusion.dashloader.api.predicates.PredicateFactory;
import net.quantumfusion.dashloader.api.predicates.SimplePredicateFactory;
import net.quantumfusion.dashloader.api.properties.BooleanPropertyFactory;
import net.quantumfusion.dashloader.api.properties.DirectionPropertyFactory;
import net.quantumfusion.dashloader.api.properties.EnumPropertyFactory;
import net.quantumfusion.dashloader.api.properties.IntPropertyFactory;
import net.quantumfusion.dashloader.api.properties.PropertyFactory;
import net.quantumfusion.dashloader.models.predicates.DashStaticPredicate;
import net.quantumfusion.dashloader.util.ThreadHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashLoaderAPI {
    public static final Logger LOGGER = LogManager.getLogger();
    public final Map<Class<? extends class_1087>, ModelFactory> modelMappings = new ConcurrentHashMap<Class<? extends class_1087>, ModelFactory>();
    public final Map<Class<? extends class_2769>, PropertyFactory> propertyMappings = new ConcurrentHashMap<Class<? extends class_2769>, PropertyFactory>();
    public final Map<Class<? extends class_390>, FontFactory> fontMappings;
    public final Map<Class<? extends class_815>, PredicateFactory> predicateMappings = new ConcurrentHashMap<Class<? extends class_815>, PredicateFactory>();
    public List<Class<?>> modelTypes;
    public List<Class<?>> predicateTypes;
    public List<Class<?>> fontTypes;
    public List<Class<?>> propertyTypes;
    public List<Class<?>> propertyValueTypes;

    public DashLoaderAPI() {
        this.fontMappings = new ConcurrentHashMap<Class<? extends class_390>, FontFactory>();
        this.modelTypes = new ArrayList();
        this.predicateTypes = new ArrayList();
        this.fontTypes = new ArrayList();
        this.propertyTypes = new ArrayList();
        this.propertyValueTypes = new ArrayList();
    }

    private void addModelType(ModelFactory factory) {
        this.modelMappings.put(factory.getType(), factory);
    }

    private void addPropertyType(PropertyFactory factory) {
        this.propertyMappings.put(factory.getType(), factory);
    }

    private void addFontType(FontFactory factory) {
        this.fontMappings.put(factory.getType(), factory);
    }

    private void addPredicateType(PredicateFactory factory) {
        this.predicateMappings.put(factory.getType(), factory);
    }

    private void clearAPI() {
        this.modelMappings.clear();
        this.propertyMappings.clear();
        this.fontMappings.clear();
        this.predicateMappings.clear();
        this.modelTypes.clear();
        this.predicateTypes.clear();
        this.fontTypes.clear();
        this.propertyTypes.clear();
        this.propertyValueTypes.clear();
    }

    private void initNativeAPI() {
        ThreadHelper.exec(() -> {
            this.addPropertyType(new BooleanPropertyFactory());
            this.addPropertyType(new IntPropertyFactory());
            this.addPropertyType(new EnumPropertyFactory());
            this.addPropertyType(new DirectionPropertyFactory());
        }, () -> {
            this.addModelType(new BasicBakedModelFactory());
            this.addModelType(new BuiltInBakedModelFactory());
            this.addModelType(new MultipartBakedModelFactory());
            this.addModelType(new WeightedBakedModelFactory());
        }, () -> {
            this.addPredicateType(new AndPredicateFactory());
            this.addPredicateType(new OrPredicateFactory());
            this.addPredicateType(new SimplePredicateFactory());
            this.predicateTypes.add(DashStaticPredicate.class);
        }, () -> {
            this.addFontType(new BitmapFontFactory());
            this.addFontType(new BlankFontFactory());
            this.addFontType(new UnicodeFontFactory());
        });
    }

    private void initTypes() {
        ThreadHelper.exec(() -> this.modelTypes.addAll(this.modelMappings.values().stream().map(Factory::getDashType).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList())), () -> this.predicateTypes.addAll(this.predicateMappings.values().stream().map(Factory::getDashType).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList())), () -> this.fontTypes.addAll(this.fontMappings.values().stream().map(Factory::getDashType).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList())), () -> {
            this.propertyTypes.addAll(this.propertyMappings.values().stream().map(Factory::getDashType).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList()));
            this.propertyValueTypes.addAll(this.propertyMappings.values().stream().map(PropertyFactory::getDashValueType).sorted(Comparator.comparing(Class::getSimpleName)).collect(Collectors.toList()));
        });
    }

    public void initAPI() {
        Instant start = Instant.now();
        this.clearAPI();
        this.initNativeAPI();
        FabricLoader.getInstance().getAllMods().parallelStream().forEach(modContainer -> {
            ModMetadata metadata = modContainer.getMetadata();
            this.getValue(metadata.getCustomValue("dashloader:factory"), metadata);
        });
        this.initTypes();
        LOGGER.info("[" + Duration.between(start, Instant.now()).toMillis() + "ms] Initialized api.");
    }

    private void getValue(CustomValue values, ModMetadata modMetadata) {
        if (values != null) {
            try {
                block9: for (CustomValue value : values.getAsArray()) {
                    Factory factory = (Factory)Unsafe.allocateInstance(Class.forName(value.getAsString()));
                    switch (factory.getFactoryType()) {
                        case MODEL: {
                            ModelFactory modelProxy = (ModelFactory)factory;
                            this.addModelType(modelProxy);
                            break;
                        }
                        case PREDICATE: {
                            PredicateFactory predicateProxy = (PredicateFactory)factory;
                            this.addPredicateType(predicateProxy);
                            break;
                        }
                        case FONT: {
                            FontFactory fontProxy = (FontFactory)factory;
                            this.addFontType(fontProxy);
                            break;
                        }
                        case PROPERTY: {
                            PropertyFactory propertyFactory = (PropertyFactory)factory;
                            this.addPropertyType(propertyFactory);
                            break;
                        }
                        case DEFAULT: {
                            LOGGER.warn("Proxy Type not set" + value.getAsString());
                            continue block9;
                        }
                        default: {
                            LOGGER.warn("Proxy Type unknown." + value.getAsString());
                            continue block9;
                        }
                    }
                    LOGGER.info("Added custom " + factory.getFactoryType().name + ": " + factory.getType().getSimpleName());
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Factory not found in mod: " + modMetadata.getName() + " with value: \"" + values.getAsString() + "\"");
            }
        }
    }
}

