/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.atlas;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeNullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.gudenau.lib.unsafe.Unsafe;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.quantumfusion.dashloader.DashRegistry;
import net.quantumfusion.dashloader.atlas.DashAnimationResourceMetadata;
import net.quantumfusion.dashloader.atlas.DashSpriteInfo;
import net.quantumfusion.dashloader.atlas.DashSpriteInterpolation;
import net.quantumfusion.dashloader.mixin.SpriteAccessor;
import net.quantumfusion.dashloader.util.Dashable;
import org.jetbrains.annotations.Nullable;

public class DashSprite
implements Dashable {
    @Serialize(order=0)
    public final DashSpriteInfo info;
    @Serialize(order=1)
    public final DashAnimationResourceMetadata animationMetadata;
    @Serialize(order=2)
    public final int[] frameXs;
    @Serialize(order=3)
    public final int[] frameYs;
    @Serialize(order=4)
    @SerializeNullable
    @Nullable
    public final DashSpriteInterpolation interpolation;
    @Serialize(order=5)
    public final int x;
    @Serialize(order=6)
    public final int y;
    @Serialize(order=7)
    public final float uMin;
    @Serialize(order=8)
    public final float uMax;
    @Serialize(order=9)
    public final float vMin;
    @Serialize(order=10)
    public final float vMax;
    @Serialize(order=11)
    public final int frameIndex;
    @Serialize(order=12)
    public final int frameTicks;
    @Serialize(order=13)
    public List<Long> images;

    public DashSprite(@Deserialize(value="info") DashSpriteInfo info, @Deserialize(value="animationMetadata") DashAnimationResourceMetadata animationMetadata, @Deserialize(value="frameXs") int[] frameXs, @Deserialize(value="frameYs") int[] frameYs, @Deserialize(value="interpolation") @Nullable DashSpriteInterpolation interpolation, @Deserialize(value="x") int x, @Deserialize(value="y") int y, @Deserialize(value="uMin") float uMin, @Deserialize(value="uMax") float uMax, @Deserialize(value="vMin") float vMin, @Deserialize(value="vMax") float vMax, @Deserialize(value="frameIndex") int frameIndex, @Deserialize(value="frameTicks") int frameTicks, @Deserialize(value="images") List<Long> images) {
        this.info = info;
        this.animationMetadata = animationMetadata;
        this.images = images;
        this.frameXs = frameXs;
        this.frameYs = frameYs;
        this.interpolation = interpolation;
        this.x = x;
        this.y = y;
        this.uMin = uMin;
        this.uMax = uMax;
        this.vMin = vMin;
        this.vMax = vMax;
        this.frameIndex = frameIndex;
        this.frameTicks = frameTicks;
    }

    public DashSprite(class_1058 sprite, DashRegistry registry) {
        SpriteAccessor spriteAccess = (SpriteAccessor)sprite;
        this.info = new DashSpriteInfo(spriteAccess.getInfo(), registry);
        this.animationMetadata = new DashAnimationResourceMetadata(spriteAccess.getAnimationMetadata());
        this.images = new ArrayList<Long>();
        Arrays.stream(spriteAccess.getImages()).forEach(nativeImage -> this.images.add(registry.createImagePointer((class_1011)nativeImage)));
        this.frameXs = spriteAccess.getFrameXs();
        this.frameYs = spriteAccess.getFrameYs();
        class_1058.class_4728 interpolation = spriteAccess.getInterpolation();
        this.interpolation = interpolation != null ? new DashSpriteInterpolation(spriteAccess.getInterpolation(), registry) : null;
        this.x = spriteAccess.getX();
        this.y = spriteAccess.getY();
        this.uMin = spriteAccess.getUMin();
        this.uMax = spriteAccess.getUMax();
        this.vMin = spriteAccess.getVMin();
        this.vMax = spriteAccess.getVMax();
        this.frameIndex = spriteAccess.getFrameIndex();
        this.frameTicks = spriteAccess.getFrameTicks();
    }

    public final class_1058 toUndash(DashRegistry registry) {
        class_1058 out = (class_1058)Unsafe.allocateInstance(class_1058.class);
        SpriteAccessor spriteAccessor = (SpriteAccessor)out;
        spriteAccessor.setInfo(this.info.toUndash(registry));
        spriteAccessor.setAnimationMetadata(this.animationMetadata.toUndash());
        ArrayList imagesOut = new ArrayList();
        this.images.forEach(dashImage -> imagesOut.add(registry.getImage((Long)dashImage)));
        spriteAccessor.setImages(imagesOut.toArray(new class_1011[0]));
        spriteAccessor.setFrameXs(this.frameXs);
        spriteAccessor.setFrameYs(this.frameYs);
        if (this.interpolation != null) {
            spriteAccessor.setInterpolation(this.interpolation.toUndash(out, registry));
        } else {
            spriteAccessor.setInterpolation(null);
        }
        spriteAccessor.setX(this.x);
        spriteAccessor.setY(this.y);
        spriteAccessor.setUMin(this.uMin);
        spriteAccessor.setUMax(this.uMax);
        spriteAccessor.setVMin(this.vMin);
        spriteAccessor.setVMax(this.vMax);
        spriteAccessor.setFrameIndex(this.frameIndex);
        spriteAccessor.setFrameTicks(this.frameTicks);
        return out;
    }
}

