/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.font;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_376;
import net.minecraft.class_377;
import net.minecraft.class_390;
import net.minecraft.class_391;
import net.minecraft.class_394;
import net.minecraft.class_4080;
import net.quantumfusion.dashloader.DashLoader;
import net.quantumfusion.dashloader.mixin.FontManagerAccessor;
import net.quantumfusion.dashloader.mixin.UnicodeTextureFontAccessor;
import net.quantumfusion.dashloader.util.DashCacheState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FastFontManager {
    private final FontManagerAccessor fontManager;
    private static final Logger LOGGER = LogManager.getLogger();
    public final class_3302 resourceReloadListener = new class_4080<Map<class_2960, List<class_390>>>(){

        protected Map<class_2960, List<class_390>> prepare(class_3300 resourceManager, class_3695 profiler) {
            Map<class_2960, List<class_390>> fontsOut = DashLoader.getInstance().getFontsOut();
            if (fontsOut != null && DashLoader.getInstance().state == DashCacheState.LOADED) {
                fontsOut.forEach((identifier, list) -> list.forEach(font -> {
                    if (font instanceof class_391) {
                        ((UnicodeTextureFontAccessor)font).setResourceManager(resourceManager);
                    }
                }));
                return fontsOut;
            }
            System.out.println("font override");
            profiler.method_16065();
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            HashMap map = Maps.newHashMap();
            for (class_2960 identifier2 : resourceManager.method_14488("font", stringx -> stringx.endsWith(".json"))) {
                String string = identifier2.method_12832();
                class_2960 identifier22 = new class_2960(identifier2.method_12836(), string.substring("font/".length(), string.length() - ".json".length()));
                List list2 = map.computeIfAbsent(identifier22, identifierx -> Lists.newArrayList((Object[])new class_390[]{new class_376()}));
                profiler.method_15400(() -> ((class_2960)identifier22).toString());
                try {
                    class_3298 resource = resourceManager.method_14486(identifier2);
                    profiler.method_15400(() -> ((class_3298)resource).method_14480());
                    try (InputStream inputStream = resource.method_14482();
                         BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        profiler.method_15396("reading");
                        JsonArray jsonArray = class_3518.method_15261((JsonObject)((JsonObject)Objects.requireNonNull(class_3518.method_15276((Gson)gson, (Reader)reader, JsonObject.class))), (String)"providers");
                        profiler.method_15405("parsing");
                        for (int i = jsonArray.size() - 1; i >= 0; --i) {
                            JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonArray.get(i), (String)("providers[" + i + "]"));
                            try {
                                String string2 = class_3518.method_15265((JsonObject)jsonObject, (String)"type");
                                profiler.method_15396(string2);
                                class_390 font = class_394.method_2048((String)string2).method_2047(jsonObject).method_2039(resourceManager);
                                if (font != null) {
                                    list2.add(font);
                                }
                                profiler.method_15407();
                                continue;
                            }
                            catch (RuntimeException var49) {
                                LOGGER.warn("Unable to read definition '{}' in fonts.json in resourcepack: '{}': {}", (Object)identifier22, (Object)resource.method_14480(), (Object)var49.getMessage());
                            }
                        }
                        profiler.method_15407();
                    }
                    catch (RuntimeException var54) {
                        LOGGER.warn("Unable to load font '{}' in fonts.json in resourcepack: '{}': {}", (Object)identifier22, (Object)resource.method_14480(), (Object)var54.getMessage());
                    }
                    profiler.method_15407();
                }
                catch (IOException var55) {
                    LOGGER.warn("Unable to load font '{}' in fonts.json: {}", (Object)identifier22, (Object)var55.getMessage());
                }
                profiler.method_15396("caching");
                profiler.method_15407();
                profiler.method_15407();
            }
            return map;
        }

        protected void apply(Map<class_2960, List<class_390>> map, class_3300 resourceManager, class_3695 profiler) {
            profiler.method_16065();
            profiler.method_15396("closing");
            FastFontManager.this.fontManager.getFontStorages().values().forEach(class_377::close);
            FastFontManager.this.fontManager.getFontStorages().clear();
            profiler.method_15405("reloading");
            map.forEach((identifier, list) -> {
                class_377 fontStorage = new class_377(FastFontManager.this.fontManager.getTextureManager(), identifier);
                fontStorage.method_2004(Lists.reverse((List)list));
                FastFontManager.this.fontManager.getFontStorages().put((class_2960)identifier, fontStorage);
            });
            DashLoader.getInstance().fonts = map;
            profiler.method_15407();
            profiler.method_16066();
        }

        public String method_22322() {
            return "FontManager";
        }
    };

    public FastFontManager(FontManagerAccessor fontManager) {
        this.fontManager = fontManager;
    }
}

