/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.quantumfusion.dashloader.DashLoader;
import net.quantumfusion.dashloader.DashRegistry;
import net.quantumfusion.dashloader.util.Dashable;
import net.quantumfusion.dashloader.util.UndashTask;

public class ThreadHelper {
    public static void exec(Runnable ... runnables) {
        List futures = DashLoader.THREADPOOL.invokeAll(Arrays.stream(runnables).map(Executors::callable).collect(Collectors.toList()));
        ThreadHelper.sleepUntilTrue(() -> futures.stream().allMatch(Future::isDone));
    }

    public static <V, D extends Dashable> Map<Long, V> execParallel(Map<Long, D> dashables, DashRegistry registry) {
        HashMap answerMap = new HashMap(dashables.size());
        Collection invoke = (Collection)DashLoader.THREADPOOL.invoke(new UndashTask(new ArrayList<Map.Entry<Long, D>>(dashables.entrySet()), 100, registry));
        invoke.forEach(answer -> answerMap.put(answer.getKey(), answer.getValue()));
        return answerMap;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleepUntilTrue(Supplier<Boolean> supplier) {
        while (!supplier.get().booleanValue()) {
            ThreadHelper.sleep(100L);
        }
    }

    public static void sleepUntilFalse(Supplier<Boolean> supplier) {
        while (supplier.get().booleanValue()) {
            ThreadHelper.sleep(100L);
        }
    }

    public static void sleepUntilTrue(Supplier<Boolean> supplier, long millis) {
        while (!supplier.get().booleanValue()) {
            ThreadHelper.sleep(millis);
        }
    }

    public static void sleepUntilFalse(Supplier<Boolean> supplier, long millis) {
        while (supplier.get().booleanValue()) {
            ThreadHelper.sleep(millis);
        }
    }
}

