/*
 * Decompiled with CFR 0.152.
 */
package net.quantumfusion.dashloader.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;
import net.quantumfusion.dashloader.DashRegistry;
import net.quantumfusion.dashloader.models.DashModel;
import net.quantumfusion.dashloader.util.Dashable;
import org.apache.commons.lang3.tuple.Pair;

public class UndashTask<K, D extends Dashable>
extends RecursiveTask<Collection<Map.Entry<Long, K>>> {
    private final List<Map.Entry<Long, D>> tasks;
    private final int threshold;
    private final DashRegistry registry;

    public UndashTask(List<Map.Entry<Long, D>> tasks, int threshold, DashRegistry registry) {
        this.tasks = tasks;
        this.threshold = threshold;
        this.registry = registry;
    }

    public Pair<List<Map.Entry<Long, D>>, List<Map.Entry<Long, D>>> split(List<Map.Entry<Long, D>> list, int size) {
        int i;
        ArrayList<Map.Entry<Long, D>> first = new ArrayList<Map.Entry<Long, D>>();
        ArrayList<Map.Entry<Long, D>> second = new ArrayList<Map.Entry<Long, D>>();
        int i1 = size / 2;
        for (i = 0; i < i1; ++i) {
            first.add(list.get(i));
        }
        for (i = i1; i < size; ++i) {
            second.add(list.get(i));
        }
        return Pair.of(first, second);
    }

    @Override
    protected Collection<Map.Entry<Long, K>> compute() {
        int size = this.tasks.size();
        if (size < this.threshold) {
            return this.computeDirectly();
        }
        Pair<List<Map.Entry<Long, D>>, List<Map.Entry<Long, D>>> subtask = this.split(this.tasks, size);
        UndashTask<K, D> subTask1 = new UndashTask<K, D>((List)subtask.getKey(), this.threshold, this.registry);
        UndashTask<K, D> subTask2 = new UndashTask<K, D>((List)subtask.getValue(), this.threshold, this.registry);
        UndashTask.invokeAll(subTask1, subTask2);
        return this.combine((Collection)subTask1.join(), (Collection)subTask2.join());
    }

    public final Collection<Map.Entry<Long, K>> combine(Collection<Map.Entry<Long, K>> list, Collection<Map.Entry<Long, K>> list2) {
        list.addAll(list2);
        return list;
    }

    protected final Collection<Map.Entry<Long, K>> computeDirectly() {
        ArrayList<Map.Entry<Long, K>> count = new ArrayList<Map.Entry<Long, K>>();
        this.tasks.forEach(dashable -> count.add((Map.Entry<Long, K>)Pair.of(dashable.getKey(), ((Dashable)dashable.getValue()).toUndash(this.registry))));
        return count;
    }

    public static class ApplyTask
    extends RecursiveAction {
        final List<DashModel> tasks;
        final int threshold;
        final DashRegistry registry;

        public ApplyTask(List<DashModel> tasks, int threshold, DashRegistry registry) {
            this.tasks = tasks;
            this.threshold = threshold;
            this.registry = registry;
        }

        public final Pair<List<DashModel>, List<DashModel>> split(List<DashModel> list, int size) {
            int i;
            ArrayList<DashModel> first = new ArrayList<DashModel>();
            ArrayList<DashModel> second = new ArrayList<DashModel>();
            int i1 = size / 2;
            for (i = 0; i < i1; ++i) {
                first.add(list.get(i));
            }
            for (i = i1; i < size; ++i) {
                second.add(list.get(i));
            }
            return Pair.of(first, second);
        }

        @Override
        protected void compute() {
            int size = this.tasks.size();
            if (size < this.threshold) {
                this.computeDirectly();
            } else {
                Pair<List<DashModel>, List<DashModel>> subtask = this.split(this.tasks, size);
                ApplyTask subTask1 = new ApplyTask((List)subtask.getKey(), this.threshold, this.registry);
                ApplyTask subTask2 = new ApplyTask((List)subtask.getValue(), this.threshold, this.registry);
                ApplyTask.invokeAll(subTask1, subTask2);
            }
        }

        protected void computeDirectly() {
            this.tasks.forEach(dashable -> dashable.apply(this.registry));
        }
    }
}

