/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureClassLoader;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.oskarstrom.dashloader.DashMappings;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.api.DashLoaderAPI;
import net.oskarstrom.dashloader.api.feature.FeatureHandler;
import net.oskarstrom.dashloader.data.DashRegistryData;
import net.oskarstrom.dashloader.data.VanillaData;
import net.oskarstrom.dashloader.data.registry.RegistryImageData;
import net.oskarstrom.dashloader.data.registry.RegistryModelData;
import net.oskarstrom.dashloader.data.serializers.DashSerializers;
import net.oskarstrom.dashloader.util.ClassLoaderWrapper;
import net.oskarstrom.dashloader.util.DashReport;
import net.oskarstrom.dashloader.util.ThreadHelper;
import net.oskarstrom.dashloader.util.TimeHelper;
import net.oskarstrom.dashloader.util.enums.DashCachePaths;
import net.oskarstrom.dashloader.util.enums.DashCacheState;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashLoader {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("dashloader").get()).getMetadata().getVersion().getFriendlyString();
    public static final TaskHandler TASK_HANDLER = new TaskHandler(LOGGER);
    private static final Path CONFIG = FabricLoader.getInstance().getConfigDir().normalize();
    private static final VanillaData VANILLA_DATA = new VanillaData();
    public static ForkJoinPool THREAD_POOL;
    private static boolean shouldReload;
    private static DashLoader instance;
    private final ClassLoaderWrapper classLoader;
    private final DashLoaderAPI api;
    public DashCacheState state;
    private DashMappings mappings;
    private DashMetadata metadata;

    public DashLoader(ClassLoader classLoader) {
        instance = this;
        this.classLoader = new ClassLoaderWrapper((SecureClassLoader)classLoader);
        this.api = new DashLoaderAPI();
        LOGGER.info("Created DashLoader");
    }

    public static Path getConfig() {
        return CONFIG;
    }

    public static DashLoader getInstance() {
        return instance;
    }

    public static VanillaData getVanillaData() {
        return VANILLA_DATA;
    }

    public DashMappings getMappings() {
        return this.mappings;
    }

    public DashLoaderAPI getApi() {
        return this.api;
    }

    public void requestReload() {
        shouldReload = true;
    }

    public ClassLoaderWrapper getAssignedClassLoader() {
        return this.classLoader;
    }

    public void initialize() {
        Instant start = Instant.now();
        LOGGER.info("Initializing DashLoader " + VERSION + ".");
        FabricLoader instance = FabricLoader.getInstance();
        if (instance.isDevelopmentEnvironment()) {
            LOGGER.warn("DashLoader launched in dev.");
        }
        this.metadata = new DashMetadata();
        this.metadata.setMods(instance);
        this.state = DashCacheState.EMPTY;
        this.initThreadPool();
        DashSerializers.initSerializers();
        DashReport.addEntry(new DashReport.Entry(start, "Initialization", true));
        LOGGER.info("Initialized DashLoader");
    }

    public void reload(Collection<String> resourcePacks) {
        if (shouldReload) {
            Instant time = Instant.now();
            DashReport.addTime(time, "From reload");
            this.state = DashCacheState.EMPTY;
            if (THREAD_POOL.isTerminated()) {
                this.initThreadPool();
            }
            this.metadata.setResourcePacks(resourcePacks);
            LOGGER.info("Reloading DashLoader. [mod-hash: {}] [resource-hash: {}]", (Object)this.metadata.modInfo, (Object)this.metadata.resourcePacks);
            if (Arrays.stream(DashCachePaths.values()).allMatch(dashCachePaths -> Files.exists(dashCachePaths.getPath(), new LinkOption[0]))) {
                this.loadDashCache();
            }
            this.shutdownThreadPool();
            LOGGER.info("Reloaded DashLoader");
            shouldReload = false;
            DashReport.addEntry(new DashReport.Entry(time, "Reload", true));
        }
    }

    public void loadDashCache() {
        block5: {
            LOGGER.info("Starting DashLoader Deserialization");
            try {
                DashRegistry registry = new DashRegistry(this);
                ThreadHelper.exec(() -> registry.loadData(DashSerializers.REGISTRY_SERIALIZER.deserializeObject(DashCachePaths.REGISTRY_CACHE.getPath(), "Cache")), () -> registry.loadModelData(DashSerializers.MODEL_SERIALIZER.deserializeObject(DashCachePaths.REGISTRY_MODEL_CACHE.getPath(), "Model Cache")), () -> registry.loadImageData(DashSerializers.IMAGE_SERIALIZER.deserializeObject(DashCachePaths.REGISTRY_IMAGE_CACHE.getPath(), "Image Cache")), () -> {
                    this.mappings = DashSerializers.MAPPING_SERIALIZER.deserializeObject(DashCachePaths.MAPPINGS_CACHE.getPath(), "Mapping");
                });
                assert (this.mappings != null);
                LOGGER.info("      Loading Registry");
                registry.toUndash();
                LOGGER.info("      Loading Mappings");
                this.mappings.toUndash(registry, VANILLA_DATA);
                LOGGER.info("    Loaded DashLoader");
                this.state = DashCacheState.LOADED;
            }
            catch (Exception e) {
                this.state = DashCacheState.CRASHLOADER;
                LOGGER.error("DashLoader has devolved to CrashLoader???", (Throwable)e);
                if (FabricLoader.getInstance().isDevelopmentEnvironment()) break block5;
                try {
                    Files.deleteIfExists(this.getModBoundDir());
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    public void finish() {
        VANILLA_DATA.clearData();
    }

    public void saveDashCache() {
        Instant start = Instant.now();
        TASK_HANDLER.reset();
        TaskHandler.setTotalTasks(FeatureHandler.calculateTasks());
        this.initThreadPool();
        this.api.initAPI();
        TASK_HANDLER.completedTask();
        DashRegistry registry = new DashRegistry(this);
        DashMappings mappings = new DashMappings();
        mappings.loadVanillaData(VANILLA_DATA, registry, TASK_HANDLER);
        Triple<DashRegistryData, RegistryImageData, RegistryModelData> data = registry.createData();
        DashSerializers.REGISTRY_SERIALIZER.serializeObject((DashRegistryData)data.getLeft(), DashCachePaths.REGISTRY_CACHE.getPath(), "Cache");
        DashSerializers.IMAGE_SERIALIZER.serializeObject((RegistryImageData)data.getMiddle(), DashCachePaths.REGISTRY_IMAGE_CACHE.getPath(), "Image Cache");
        DashSerializers.MODEL_SERIALIZER.serializeObject((RegistryModelData)data.getRight(), DashCachePaths.REGISTRY_MODEL_CACHE.getPath(), "Model Cache");
        DashSerializers.MAPPING_SERIALIZER.serializeObject(mappings, DashCachePaths.MAPPINGS_CACHE.getPath(), "Mapping");
        registry.apiReport(LOGGER);
        this.shutdownThreadPool();
        TASK_HANDLER.setCurrentTask("Caching is now complete.");
        LOGGER.info("Created cache in " + TimeHelper.getDecimalS(start, Instant.now()) + "s");
    }

    private void initThreadPool() {
        if (THREAD_POOL == null || THREAD_POOL.isTerminated()) {
            ForkJoinPool.ForkJoinWorkerThreadFactory factory = ForkJoinPool.defaultForkJoinWorkerThreadFactory;
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (thread, exception) -> LOGGER.fatal("Thread {} failed. Reason: ", (Object)thread.getName(), (Object)exception);
            THREAD_POOL = new ForkJoinPool(Runtime.getRuntime().availableProcessors(), pool -> {
                ForkJoinWorkerThread worker = factory.newThread(pool);
                worker.setName("dashloader-thread-" + worker.getPoolIndex());
                worker.setContextClassLoader(this.classLoader);
                return worker;
            }, uncaughtExceptionHandler, true);
        }
    }

    private void shutdownThreadPool() {
        THREAD_POOL.shutdown();
    }

    public Path getModBoundDir() {
        try {
            Path resolve = DashLoader.getConfig().resolve("quantumfusion/dashloader/mods-" + this.metadata.modInfo + "/");
            return Files.createDirectories(resolve, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not create ModBoundDir: ", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    public Path getResourcePackBoundDir() {
        try {
            Path resolve = this.getModBoundDir().resolve("resourcepacks-" + this.metadata.resourcePacks + "/");
            return Files.createDirectories(resolve, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not create ResourcePackBoundDir: ", (Throwable)e);
            throw new IllegalStateException();
        }
    }

    static {
        shouldReload = true;
    }

    public static class DashMetadata {
        public String modInfo;
        public String resourcePacks;

        public void setMods(FabricLoader loader) {
            long modInfoData = 0L;
            for (ModContainer mod : loader.getAllMods()) {
                for (char c : mod.getMetadata().getVersion().getFriendlyString().toCharArray()) {
                    modInfoData += (long)c;
                }
            }
            this.modInfo = Long.toHexString(modInfoData);
        }

        public void setResourcePacks(Collection<String> resourcePacks) {
            long resourcePackData = 0L;
            for (String resourcePack : resourcePacks) {
                for (char c : resourcePack.toCharArray()) {
                    resourcePackData += (long)c;
                }
            }
            this.resourcePacks = Long.toHexString(resourcePackData);
        }

        public String getId() {
            return this.modInfo + "-" + this.resourcePacks;
        }
    }

    public static class TaskHandler {
        public static int TOTALTASKS = 9;
        private static float taskStep = 1.0f / (float)TOTALTASKS;
        private final Logger logger;
        private String task = "Starting DashLoader";
        private int tasksComplete = 0;
        private int subTotalTasks = 1;
        private int subTasksComplete = 0;

        public TaskHandler(Logger logger) {
            this.logger = logger;
        }

        public static void setTotalTasks(int tasks) {
            TOTALTASKS = tasks;
            taskStep = 1.0f / (float)TOTALTASKS;
        }

        public void logAndTask(String s) {
            this.logger.info(s);
            ++this.tasksComplete;
            this.task = s;
        }

        public void reset() {
            this.tasksComplete = 0;
            this.subTotalTasks = 1;
            this.subTasksComplete = 0;
        }

        public void completedTask() {
            ++this.tasksComplete;
        }

        public void setCurrentTask(String task) {
            this.task = task;
        }

        public void setSubtasks(int tasks) {
            this.subTotalTasks = tasks;
            this.subTasksComplete = 0;
        }

        public void completedSubTask() {
            ++this.subTasksComplete;
        }

        public class_2561 getText() {
            return class_2561.method_30163((String)("(" + this.tasksComplete + "/" + TOTALTASKS + ") " + this.task));
        }

        public class_2561 getSubText() {
            return TOTALTASKS == this.tasksComplete ? class_2561.method_30163((String)"") : class_2561.method_30163((String)("[" + this.subTasksComplete + "/" + this.subTotalTasks + "] "));
        }

        public double getProgress() {
            return this.subTasksComplete == this.subTotalTasks && this.tasksComplete == TOTALTASKS ? 1.0 : (double)((this.tasksComplete == 0 ? 0.0f : (float)this.tasksComplete / (float)TOTALTASKS) + (float)this.subTasksComplete / (float)this.subTotalTasks * taskStep);
        }
    }
}

