/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader;

import com.mojang.blaze3d.platform.TextureUtil;
import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeNullable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1044;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.api.feature.Feature;
import net.oskarstrom.dashloader.data.VanillaData;
import net.oskarstrom.dashloader.data.mappings.DashBlockStateData;
import net.oskarstrom.dashloader.data.mappings.DashFontManagerData;
import net.oskarstrom.dashloader.data.mappings.DashModelData;
import net.oskarstrom.dashloader.data.mappings.DashParticleData;
import net.oskarstrom.dashloader.data.mappings.DashShaderData;
import net.oskarstrom.dashloader.data.mappings.DashSplashTextData;
import net.oskarstrom.dashloader.data.mappings.DashSpriteAtlasData;
import net.oskarstrom.dashloader.image.DashSpriteAtlasTextureData;
import net.oskarstrom.dashloader.mixin.accessor.AbstractTextureAccessor;
import net.oskarstrom.dashloader.mixin.accessor.SpriteAccessor;
import net.oskarstrom.dashloader.mixin.accessor.SpriteAtlasTextureAccessor;
import net.oskarstrom.dashloader.util.DashHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class DashMappings {
    @Serialize(order=0)
    @SerializeNullable
    public DashBlockStateData blockStateData;
    @Serialize(order=1)
    @SerializeNullable
    public DashFontManagerData fontManagerData;
    @Serialize(order=2)
    @SerializeNullable
    public DashModelData modelData;
    @Serialize(order=3)
    @SerializeNullable
    public DashParticleData particleData;
    @Serialize(order=4)
    @SerializeNullable
    public DashSplashTextData splashTextData;
    @Serialize(order=5)
    @SerializeNullable
    public DashSpriteAtlasData spriteAtlasData;
    @Serialize(order=6)
    @SerializeNullable
    public DashShaderData shaderData;
    private List<Pair<Feature, Pair<class_1059, DashSpriteAtlasTextureData>>> atlasesToRegister;

    public DashMappings() {
    }

    public DashMappings(@Deserialize(value="blockStateData") DashBlockStateData blockStateData, @Deserialize(value="fontManagerData") DashFontManagerData fontManagerData, @Deserialize(value="modelData") DashModelData modelData, @Deserialize(value="particleData") DashParticleData particleData, @Deserialize(value="splashTextData") DashSplashTextData splashTextData, @Deserialize(value="spriteAtlasData") DashSpriteAtlasData spriteAtlasData, @Deserialize(value="shaderData") DashShaderData shaderData) {
        this.blockStateData = blockStateData;
        this.fontManagerData = fontManagerData;
        this.modelData = modelData;
        this.particleData = particleData;
        this.splashTextData = splashTextData;
        this.spriteAtlasData = spriteAtlasData;
        this.shaderData = shaderData;
    }

    public void loadVanillaData(VanillaData data, DashRegistry registry, DashLoader.TaskHandler taskHandler) {
        if (Feature.MODEL_LOADER.active()) {
            taskHandler.logAndTask("Mapping Blockstates");
            this.blockStateData = new DashBlockStateData(data, registry, taskHandler);
            taskHandler.logAndTask("Mapping Models");
            this.modelData = new DashModelData(data, registry, taskHandler);
            taskHandler.logAndTask("Mapping Atlas");
            this.spriteAtlasData = new DashSpriteAtlasData(data, registry, taskHandler);
        }
        if (Feature.PARTICLES.active()) {
            taskHandler.logAndTask("Mapping Particles");
            this.particleData = new DashParticleData(data, registry, taskHandler);
        }
        if (Feature.FONTS.active()) {
            taskHandler.logAndTask("Mapping Fonts");
            this.fontManagerData = new DashFontManagerData(data, registry, taskHandler);
        }
        if (Feature.SPLASH_TEXT.active()) {
            taskHandler.logAndTask("Mapping Splash Text");
            this.splashTextData = new DashSplashTextData(data, taskHandler);
        }
        if (Feature.SHADERS.active()) {
            taskHandler.logAndTask("Mapping Shaders");
            this.shaderData = new DashShaderData(data, taskHandler);
        }
    }

    public void toUndash(DashRegistry registry, VanillaData vanillaData) {
        Pair spriteData = DashHelper.nullable(this.spriteAtlasData, spriteAtlasData -> spriteAtlasData.toUndash(registry));
        Pair particleData = DashHelper.nullable(this.particleData, data -> data.toUndash(registry));
        vanillaData.loadCacheData(DashHelper.nullable(spriteData, Pair::getLeft), (Object2IntMap<class_2680>)DashHelper.nullable(this.blockStateData, data -> data.toUndash(registry)), DashHelper.nullable(this.modelData, data -> data.toUndash(registry)), DashHelper.nullable(particleData, Pair::getLeft), DashHelper.nullable(this.fontManagerData, data -> data.toUndash(registry)), DashHelper.nullable(this.splashTextData, DashSplashTextData::toUndash), DashHelper.nullable(this.shaderData, DashShaderData::toUndash));
        this.atlasesToRegister = new ArrayList<Pair<Feature, Pair<class_1059, DashSpriteAtlasTextureData>>>();
        if (spriteData != null) {
            ((List)spriteData.getValue()).forEach(atlasTexture -> this.atlasesToRegister.add((Pair<Feature, Pair<class_1059, DashSpriteAtlasTextureData>>)Pair.of((Object)((Object)Feature.MODEL_LOADER), (Object)Pair.of((Object)atlasTexture, (Object)vanillaData.getAtlasData((class_1059)atlasTexture)))));
        }
        if (particleData != null) {
            class_1059 texture = (class_1059)particleData.getRight();
            this.atlasesToRegister.add((Pair<Feature, Pair<class_1059, DashSpriteAtlasTextureData>>)Pair.of((Object)((Object)Feature.PARTICLES), (Object)Pair.of((Object)texture, (Object)vanillaData.getAtlasData(texture))));
        }
        this.modelData = null;
        this.spriteAtlasData = null;
        this.blockStateData = null;
        this.fontManagerData = null;
        this.splashTextData = null;
    }

    public void registerAtlases(class_1060 textureManager, Feature feature) {
        this.atlasesToRegister.forEach(pair -> {
            if (pair.getLeft() == feature) {
                Pair atlas = (Pair)pair.getRight();
                this.registerAtlas((class_1059)atlas.getLeft(), (DashSpriteAtlasTextureData)atlas.getRight(), textureManager);
            }
        });
    }

    public void registerAtlas(class_1059 atlasTexture, DashSpriteAtlasTextureData data, class_1060 textureManager) {
        class_2960 id = atlasTexture.method_24106();
        int glId = TextureUtil.generateTextureId();
        int width = data.width;
        int maxLevel = data.maxLevel;
        int height = data.height;
        ((AbstractTextureAccessor)atlasTexture).setGlId(glId);
        TextureUtil.prepareImage((int)glId, (int)maxLevel, (int)width, (int)height);
        ((SpriteAtlasTextureAccessor)atlasTexture).getSprites().forEach((identifier, sprite) -> {
            SpriteAccessor access = (SpriteAccessor)sprite;
            access.setAtlas(atlasTexture);
            access.setId((class_2960)identifier);
            sprite.method_4584();
        });
        textureManager.method_4616(id, (class_1044)atlasTexture);
        atlasTexture.method_4527(false, maxLevel > 0);
        DashLoader.LOGGER.info("Allocated: {}x{}x{} {}-atlas", (Object)width, (Object)height, (Object)maxLevel, (Object)id);
    }

    @Nullable
    public class_1059 getAtlas(class_2960 identifier) {
        for (Pair<Feature, Pair<class_1059, DashSpriteAtlasTextureData>> pair : this.atlasesToRegister) {
            class_1059 atlas = (class_1059)((Pair)pair.getRight()).getLeft();
            if (!identifier.equals((Object)atlas.method_24106())) continue;
            return atlas;
        }
        return null;
    }
}

