/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_390;
import net.minecraft.class_815;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.Dashable;
import net.oskarstrom.dashloader.api.FactoryConstructor;
import net.oskarstrom.dashloader.api.enums.FactoryType;
import net.oskarstrom.dashloader.blockstate.DashBlockState;
import net.oskarstrom.dashloader.blockstate.property.DashProperty;
import net.oskarstrom.dashloader.blockstate.property.value.DashPropertyValue;
import net.oskarstrom.dashloader.data.DashID;
import net.oskarstrom.dashloader.data.DashIdentifier;
import net.oskarstrom.dashloader.data.DashRegistryData;
import net.oskarstrom.dashloader.data.registry.RegistryBlockStateData;
import net.oskarstrom.dashloader.data.registry.RegistryFontData;
import net.oskarstrom.dashloader.data.registry.RegistryIdentifierData;
import net.oskarstrom.dashloader.data.registry.RegistryImageData;
import net.oskarstrom.dashloader.data.registry.RegistryModelData;
import net.oskarstrom.dashloader.data.registry.RegistryPredicateData;
import net.oskarstrom.dashloader.data.registry.RegistryPropertyData;
import net.oskarstrom.dashloader.data.registry.RegistryPropertyValueData;
import net.oskarstrom.dashloader.data.registry.RegistrySpriteData;
import net.oskarstrom.dashloader.data.serialization.Pointer2ObjectMap;
import net.oskarstrom.dashloader.font.DashFont;
import net.oskarstrom.dashloader.image.DashImage;
import net.oskarstrom.dashloader.image.DashSprite;
import net.oskarstrom.dashloader.model.DashModel;
import net.oskarstrom.dashloader.model.DashModelIdentifier;
import net.oskarstrom.dashloader.model.predicates.DashPredicate;
import net.oskarstrom.dashloader.model.predicates.DashStaticPredicate;
import net.oskarstrom.dashloader.util.ThreadHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashRegistry {
    private static int totalTasks = 6;
    private static int tasksDone = 0;
    private final Map<Integer, DashModel> models;
    public Map<Class<?>, FactoryType> apiFailed = new ConcurrentHashMap();
    public Int2ObjectMap<class_2680> blockstatesOut;
    public Int2ObjectMap<Predicate<class_2680>> predicateOut;
    public Int2ObjectMap<class_2960> identifiersOut;
    public Int2ObjectMap<class_1087> modelsOut;
    public Int2ObjectMap<class_1058> spritesOut;
    public Int2ObjectMap<class_390> fontsOut;
    public Int2ObjectMap<class_1011> imagesOut;
    public Int2ObjectMap<class_2769<?>> propertiesOut;
    public Int2ObjectMap<Comparable<?>> propertyValuesOut;
    DashLoader loader;
    private Int2ObjectMap<DashBlockState> blockstates;
    private Int2ObjectMap<DashSprite> sprites;
    private Int2ObjectMap<DashID> identifiers;
    private Int2ObjectMap<DashFont> fonts;
    private Int2ObjectMap<DashImage> images;
    private Int2ObjectMap<DashPredicate> predicates;
    private Int2ObjectMap<DashProperty> properties;
    private Int2ObjectMap<DashPropertyValue> propertyValues;
    private List<Int2ObjectMap<DashModel>> modelsToDeserialize;

    public DashRegistry(Int2ObjectMap<DashBlockState> blockstates, Int2ObjectMap<DashSprite> sprites, Int2ObjectMap<DashID> identifiers, Int2ObjectMap<DashFont> fonts, Int2ObjectMap<DashImage> images, Int2ObjectMap<DashPredicate> predicates, Int2ObjectMap<DashProperty> properties, Int2ObjectMap<DashPropertyValue> propertyValues, Map<Integer, DashModel> models) {
        this.blockstates = blockstates;
        this.sprites = sprites;
        this.identifiers = identifiers;
        this.models = models;
        this.fonts = fonts;
        this.images = images;
        this.predicates = predicates;
        this.properties = properties;
        this.propertyValues = propertyValues;
    }

    public DashRegistry(DashLoader loader) {
        this.blockstates = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.sprites = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.identifiers = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.models = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.fonts = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.predicates = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.images = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.properties = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.propertyValues = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
        this.modelsToDeserialize = new ArrayList<Int2ObjectMap<DashModel>>();
        this.loader = loader;
    }

    public Triple<DashRegistryData, RegistryImageData, RegistryModelData> createData() {
        return Triple.of((Object)new DashRegistryData(new RegistryBlockStateData(new Pointer2ObjectMap<DashBlockState>((Map<Integer, DashBlockState>)this.blockstates)), new RegistryFontData(new Pointer2ObjectMap<DashFont>((Map<Integer, DashFont>)this.fonts)), new RegistryIdentifierData(new Pointer2ObjectMap<DashID>((Map<Integer, DashID>)this.identifiers)), new RegistryPropertyData(new Pointer2ObjectMap<DashProperty>((Map<Integer, DashProperty>)this.properties)), new RegistryPropertyValueData(new Pointer2ObjectMap<DashPropertyValue>((Map<Integer, DashPropertyValue>)this.propertyValues)), new RegistrySpriteData(new Pointer2ObjectMap<DashSprite>((Map<Integer, DashSprite>)this.sprites)), new RegistryPredicateData(new Pointer2ObjectMap<DashPredicate>((Map<Integer, DashPredicate>)this.predicates))), (Object)new RegistryImageData(new Pointer2ObjectMap<DashImage>((Map<Integer, DashImage>)this.images)), (Object)this.getModels());
    }

    public void loadData(DashRegistryData registryData) {
        this.blockstates = registryData.blockStateRegistryData.toUndash();
        this.sprites = registryData.spriteRegistryData.toUndash();
        this.fonts = registryData.fontRegistryData.toUndash();
        this.predicates = registryData.predicateRegistryData.toUndash();
        this.properties = registryData.propertyRegistryData.toUndash();
        this.propertyValues = registryData.propertyValueRegistryData.toUndash();
        this.identifiers = registryData.identifierRegistryData.toUndash();
    }

    public void loadImageData(RegistryImageData dashImageData) {
        this.images = dashImageData.toUndash();
    }

    public void loadModelData(RegistryModelData modelData) {
        this.modelsToDeserialize = modelData.toUndash();
    }

    public RegistryModelData getModels() {
        HashMap<Integer, Pointer2ObjectMap> modelsToAdd = new HashMap<Integer, Pointer2ObjectMap>();
        for (Map.Entry<Integer, DashModel> entry : this.models.entrySet()) {
            DashModel value = entry.getValue();
            modelsToAdd.computeIfAbsent(value.getStage(), Pointer2ObjectMap::new).put(entry.getKey(), value);
        }
        return new RegistryModelData(new Pointer2ObjectMap<Pointer2ObjectMap<DashModel>>(modelsToAdd));
    }

    public int createBlockStatePointer(class_2680 blockState) {
        int hash = blockState.hashCode();
        if (this.blockstates.get(hash) == null) {
            this.blockstates.put(hash, (Object)new DashBlockState(blockState, this));
        }
        return hash;
    }

    public final Integer createModelPointer(class_1087 bakedModel) {
        if (bakedModel == null) {
            return null;
        }
        int hash = bakedModel.hashCode();
        if (this.models.get(hash) == null) {
            FactoryConstructor factory = this.loader.getApi().modelMappings.get(bakedModel.getClass());
            if (factory != null) {
                this.models.put(hash, (DashModel)factory.createObject(bakedModel, this));
            } else {
                this.apiFailed.putIfAbsent(bakedModel.getClass(), FactoryType.MODEL);
            }
        }
        return hash;
    }

    public final int createSpritePointer(class_1058 sprite) {
        int hash = sprite.hashCode();
        if (this.sprites.get(hash) == null) {
            this.sprites.put(hash, (Object)new DashSprite(sprite, this));
        }
        return hash;
    }

    public final int createIdentifierPointer(class_2960 identifier) {
        int hash = identifier.hashCode();
        if (this.identifiers.get(hash) == null) {
            if (identifier instanceof class_1091) {
                this.identifiers.put(hash, (Object)new DashModelIdentifier((class_1091)identifier));
            } else {
                this.identifiers.put(hash, (Object)new DashIdentifier(identifier));
            }
        }
        return hash;
    }

    public final int createImagePointer(class_1011 image) {
        int hash = image.hashCode();
        if (this.images.get(hash) == null) {
            this.images.put(hash, (Object)new DashImage(image));
        }
        return hash;
    }

    public final int createPredicatePointer(class_815 selector, class_2689<class_2248, class_2680> stateManager) {
        int hash = selector.hashCode();
        if (this.predicates.get(hash) == null) {
            this.predicates.put(hash, (Object)this.obtainPredicate(selector, stateManager));
        }
        return hash;
    }

    public final DashPredicate obtainPredicate(class_815 selector, class_2689<class_2248, class_2680> stateManager) {
        boolean isTrue;
        boolean bl = isTrue = selector == class_815.field_16900;
        if (selector == class_815.field_16901 || isTrue) {
            return new DashStaticPredicate(isTrue);
        }
        FactoryConstructor predicateFactory = this.loader.getApi().predicateMappings.get(selector.getClass());
        if (predicateFactory != null) {
            return (DashPredicate)predicateFactory.createObject(selector, this, stateManager);
        }
        this.apiFailed.putIfAbsent(selector.getClass(), FactoryType.PREDICATE);
        return null;
    }

    public final int createFontPointer(class_390 font) {
        int hash = font.hashCode();
        if (this.fonts.get(hash) == null) {
            FactoryConstructor fontFactory = this.loader.getApi().fontMappings.get(font.getClass());
            if (fontFactory != null) {
                this.fonts.put(hash, (Object)((DashFont)fontFactory.createObject(font, this)));
            } else {
                this.apiFailed.putIfAbsent(font.getClass(), FactoryType.FONT);
            }
        }
        return hash;
    }

    public final Pair<Integer, Integer> createPropertyPointer(class_2769<?> property, Comparable<?> value) {
        boolean prop;
        int hashV = value.hashCode();
        int hashP = property.hashCode();
        boolean propVal = !this.propertyValues.containsKey(hashV);
        boolean bl = prop = !this.properties.containsKey(hashP);
        if (propVal || prop) {
            DashProperty possibleProperty = null;
            if (prop) {
                FactoryConstructor propFactory = this.loader.getApi().propertyMappings.get(property.getClass());
                if (propFactory != null) {
                    possibleProperty = (DashProperty)this.properties.put(hashP, (Object)((DashProperty)propFactory.createObject(property, this, hashV)));
                } else {
                    this.apiFailed.put(property.getClass(), FactoryType.PROPERTY);
                    return Pair.of((Object)hashP, (Object)hashV);
                }
            }
            if (propVal) {
                FactoryConstructor factory = this.loader.getApi().propertyValueMappings.get(value.getClass());
                if (factory != null) {
                    this.propertyValues.put(hashV, (Object)((DashPropertyValue)factory.createObject(value, this, hashP)));
                } else {
                    FactoryConstructor forcedPropertyValue;
                    if (possibleProperty == null) {
                        FactoryConstructor propFactory = this.loader.getApi().propertyMappings.get(property.getClass());
                        if (propFactory != null) {
                            possibleProperty = (DashProperty)this.properties.put(hashP, (Object)((DashProperty)propFactory.createObject(property, this, hashV)));
                        } else {
                            this.apiFailed.put(property.getClass(), FactoryType.PROPERTY);
                            return Pair.of((Object)hashP, (Object)hashV);
                        }
                    }
                    if ((forcedPropertyValue = possibleProperty.overrideMethodHandleForValue()) != null) {
                        this.propertyValues.put(hashV, (Object)((DashPropertyValue)forcedPropertyValue.createObject(value, this, hashP)));
                    } else {
                        this.apiFailed.put(value.getClass(), FactoryType.PROPERTY_VALUE);
                    }
                }
            }
        }
        return Pair.of((Object)hashP, (Object)hashV);
    }

    public final class_2680 getBlockstate(int pointer) {
        return this.logIfNullThenReturn(this.blockstatesOut, pointer, "BlockState");
    }

    public final class_1058 getSprite(int pointer) {
        return this.logIfNullThenReturn(this.spritesOut, pointer, "Sprite");
    }

    public final class_2960 getIdentifier(int pointer) {
        return this.logIfNullThenReturn(this.identifiersOut, pointer, "Identifier");
    }

    public final class_1087 getModel(int pointer) {
        return this.logIfNullThenReturn(this.modelsOut, pointer, "BakedModel");
    }

    public final class_390 getFont(int pointer) {
        return this.logIfNullThenReturn(this.fontsOut, pointer, "Font");
    }

    public final class_1011 getImage(int pointer) {
        return this.logIfNullThenReturn(this.imagesOut, pointer, "NativeImage");
    }

    public final Predicate<class_2680> getPredicate(int pointer) {
        return this.logIfNullThenReturn(this.predicateOut, pointer, "Predicate");
    }

    public final Pair<class_2769<?>, Comparable<?>> getProperty(int propertyPointer, int valuePointer) {
        class_2769 property = (class_2769)this.propertiesOut.get(propertyPointer);
        Comparable value = (Comparable)this.propertyValuesOut.get(valuePointer);
        if (property == null || value == null) {
            DashLoader.LOGGER.error("Property not found in data. PINTR: " + propertyPointer + "/" + valuePointer);
        }
        return Pair.of((Object)property, (Object)value);
    }

    private <T> T logIfNullThenReturn(Int2ObjectMap<T> map, int ptr, String typeStr) {
        Object t = map.get(ptr);
        if (t == null) {
            DashLoader.LOGGER.error(typeStr + " not found in data. PINTR: " + ptr);
        }
        return (T)t;
    }

    public void toUndash() {
        Logger logger = LogManager.getLogger();
        try {
            tasksDone = 0;
            totalTasks = 4 + this.modelsToDeserialize.size();
            this.log(logger, "Loading Simple Objects");
            this.identifiersOut = this.parallelToUndash(this.identifiers);
            this.imagesOut = this.parallelToUndash(this.images);
            this.log(logger, "Loading Properties");
            this.propertiesOut = ThreadHelper.execParallel(this.properties, this);
            this.propertyValuesOut = ThreadHelper.execParallel(this.propertyValues, this);
            this.properties = null;
            this.propertyValues = null;
            this.log(logger, "Loading Advanced Objects");
            this.blockstatesOut = this.parallelToUndash(this.blockstates);
            this.predicateOut = this.parallelToUndash(this.predicates);
            this.spritesOut = this.parallelToUndash(this.sprites);
            this.fontsOut = this.parallelToUndash(this.fonts);
            this.modelsOut = new Int2ObjectOpenHashMap((int)Math.ceil((double)this.modelsToDeserialize.size() / 0.75));
            short[] currentStage = new short[]{0};
            this.modelsToDeserialize.forEach(modelCategory -> {
                this.log(logger, "Loading " + modelCategory.size() + " Models: [" + currentStage[0] + "]");
                this.modelsOut.putAll(ThreadHelper.execParallel(modelCategory, this));
                currentStage[0] = (short)(currentStage[0] + 1);
            });
            this.log(logger, "Applying Model Overrides");
            this.modelsToDeserialize.forEach(modelcategory -> DashLoader.THREAD_POOL.invoke(new ThreadHelper.UndashTask.ApplyTask(new ArrayList<DashModel>((Collection<DashModel>)modelcategory.values()), 100, this)));
            this.modelsToDeserialize = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <D extends Dashable<O>, O> Int2ObjectMap<O> parallelToUndash(Int2ObjectMap<D> in) {
        Int2ObjectMap out = ThreadHelper.execParallel(in, this);
        in.clear();
        return out;
    }

    private void log(Logger logger, String s) {
        logger.info("[" + ++tasksDone + "/" + totalTasks + "] " + s);
    }

    public void apiReport(Logger logger) {
        if (this.apiFailed.size() != 0) {
            logger.error("Found incompatible objects that were not able to be serialized.");
            int[] ints = new int[1];
            this.apiFailed.entrySet().stream().sorted(Comparator.comparing(e -> ((FactoryType)((Object)((Object)e.getValue()))).name)).forEach(entry -> {
                ints[0] = ints[0] + 1;
                logger.error("[" + ((FactoryType)((Object)((Object)entry.getValue()))).name() + "] Object: " + ((Class)entry.getKey()).getName());
            });
            logger.error("In total there are " + ints[0] + " incompatible objects. Please contact the mod developers to add support.");
        }
    }
}

