/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.api;

import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1087;
import net.minecraft.class_2769;
import net.minecraft.class_390;
import net.minecraft.class_815;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.api.FactoryConstructor;
import net.oskarstrom.dashloader.api.annotation.DashConstructor;
import net.oskarstrom.dashloader.api.annotation.DashObject;
import net.oskarstrom.dashloader.api.enums.ConstructorMode;
import net.oskarstrom.dashloader.api.enums.FactoryType;
import net.oskarstrom.dashloader.blockstate.property.DashBooleanProperty;
import net.oskarstrom.dashloader.blockstate.property.DashDirectionProperty;
import net.oskarstrom.dashloader.blockstate.property.DashEnumProperty;
import net.oskarstrom.dashloader.blockstate.property.DashIntProperty;
import net.oskarstrom.dashloader.blockstate.property.value.DashBooleanValue;
import net.oskarstrom.dashloader.blockstate.property.value.DashDirectionValue;
import net.oskarstrom.dashloader.blockstate.property.value.DashEnumValue;
import net.oskarstrom.dashloader.blockstate.property.value.DashIntValue;
import net.oskarstrom.dashloader.font.DashBitmapFont;
import net.oskarstrom.dashloader.font.DashBlankFont;
import net.oskarstrom.dashloader.font.DashTrueTypeFont;
import net.oskarstrom.dashloader.font.DashUnicodeFont;
import net.oskarstrom.dashloader.model.DashBasicBakedModel;
import net.oskarstrom.dashloader.model.DashBuiltinBakedModel;
import net.oskarstrom.dashloader.model.DashMultipartBakedModel;
import net.oskarstrom.dashloader.model.DashWeightedBakedModel;
import net.oskarstrom.dashloader.model.predicates.DashAndPredicate;
import net.oskarstrom.dashloader.model.predicates.DashOrPredicate;
import net.oskarstrom.dashloader.model.predicates.DashSimplePredicate;
import net.oskarstrom.dashloader.model.predicates.DashStaticPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashLoaderAPI {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Class<?>[] defaultParameters = new Class[]{DashRegistry.class};
    public final Map<Class<? extends class_1087>, FactoryConstructor> modelMappings = Collections.synchronizedMap(new HashMap());
    public final Map<Class<? extends class_2769<?>>, FactoryConstructor> propertyMappings = Collections.synchronizedMap(new HashMap());
    public final Map<Class<? extends Comparable<?>>, FactoryConstructor> propertyValueMappings = Collections.synchronizedMap(new HashMap());
    public final Map<Class<? extends class_390>, FactoryConstructor> fontMappings;
    public final Map<Class<? extends class_815>, FactoryConstructor> predicateMappings = Collections.synchronizedMap(new HashMap());
    public List<Class<?>> modelTypes;
    public List<Class<?>> predicateTypes;
    public List<Class<?>> fontTypes;
    public List<Class<?>> propertyTypes;
    public List<Class<?>> propertyValueTypes;
    private boolean initialized = false;

    public DashLoaderAPI() {
        this.fontMappings = Collections.synchronizedMap(new HashMap());
        this.modelTypes = new ArrayList();
        this.predicateTypes = new ArrayList();
        this.fontTypes = new ArrayList();
        this.propertyTypes = new ArrayList();
        this.propertyValueTypes = new ArrayList();
    }

    public static FactoryConstructor createConstructor(Class<?> dashClass, Class<?> rawClass) throws NoSuchMethodException, IllegalAccessException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = dashClass.getConstructors()) {
            DashConstructor[] dashConstructors;
            if (!constructor.isAnnotationPresent(DashConstructor.class) || (dashConstructors = (DashConstructor[])constructor.getAnnotationsByType(DashConstructor.class)).length == 0) continue;
            ConstructorMode value = dashConstructors[0].value();
            try {
                return FactoryConstructor.createConstructor(value, dashClass, rawClass);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodException(value.getExpectedMethod(dashClass, rawClass));
            }
        }
        try {
            return FactoryConstructor.createConstructor(ConstructorMode.DEFAULT_PARAMETERS, dashClass, rawClass);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException(ConstructorMode.DEFAULT_PARAMETERS.getExpectedMethod(dashClass, rawClass));
        }
    }

    private void clearAPI() {
        this.modelMappings.clear();
        this.propertyMappings.clear();
        this.propertyValueMappings.clear();
        this.fontMappings.clear();
        this.predicateMappings.clear();
        this.modelTypes.clear();
        this.predicateTypes.clear();
        this.fontTypes.clear();
        this.propertyTypes.clear();
        this.propertyValueTypes.clear();
    }

    private void addType(FactoryType type, Class<?> dashClass, Class<?> targetClass, FactoryConstructor constructor) {
        switch (type) {
            case PROPERTY_VALUE: {
                this.propertyValueTypes.add(dashClass);
                this.propertyValueMappings.put(targetClass, constructor);
                break;
            }
            case PROPERTY: {
                this.propertyTypes.add(dashClass);
                this.propertyMappings.put(targetClass, constructor);
                break;
            }
            case MODEL: {
                this.modelTypes.add(dashClass);
                this.modelMappings.put(targetClass, constructor);
                break;
            }
            case FONT: {
                this.fontTypes.add(dashClass);
                this.fontMappings.put(targetClass, constructor);
                break;
            }
            case PREDICATE: {
                this.predicateTypes.add(dashClass);
                this.predicateMappings.put(targetClass, constructor);
            }
        }
        LOGGER.info("Added custom DashObject: {} {}", (Object)type, (Object)dashClass.getSimpleName());
    }

    private FactoryType getTypeFromFactoryInterface(Class<?> closs) {
        for (FactoryType value : FactoryType.values()) {
            if (value.factoryInterface != closs) continue;
            return value;
        }
        LOGGER.error("Cannot find Factory Type from {} class parameter.", (Object)closs.getSimpleName());
        return null;
    }

    public void registerDashObject(Class<?> closs) {
        Class<?>[] interfaces = closs.getInterfaces();
        if (interfaces.length == 0) {
            LOGGER.error("No Interfaces found. Class: {}", (Object)closs.getSimpleName());
            return;
        }
        DashObject annotation = closs.getDeclaredAnnotation(DashObject.class);
        if (annotation == null) {
            LOGGER.error("Custom DashObject implementation does not have DashObject Annotation. Class: {}", (Object)closs.getSimpleName());
            return;
        }
        FactoryType type = annotation.overrideType();
        if (type == FactoryType.DEFAULT) {
            type = this.getTypeFromFactoryInterface(interfaces[0]);
        }
        if (type == null) {
            LOGGER.error("Factory type could not be identified. Class: {}", (Object)closs.getSimpleName());
            return;
        }
        Class<?> rawClass = annotation.value();
        try {
            this.addType(type, closs, rawClass, DashLoaderAPI.createConstructor(closs, rawClass));
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Constructor not matching/found. Expected: {}", (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Constructor not accessible in {}", (Object)closs.getSimpleName());
        }
    }

    private void initNativeAPI() {
        this.registerDashObject(DashBasicBakedModel.class);
        this.registerDashObject(DashBuiltinBakedModel.class);
        this.registerDashObject(DashMultipartBakedModel.class);
        this.registerDashObject(DashWeightedBakedModel.class);
        this.registerDashObject(DashAndPredicate.class);
        this.registerDashObject(DashOrPredicate.class);
        this.registerDashObject(DashSimplePredicate.class);
        this.predicateTypes.add(DashStaticPredicate.class);
        this.registerDashObject(DashBooleanProperty.class);
        this.registerDashObject(DashDirectionProperty.class);
        this.registerDashObject(DashEnumProperty.class);
        this.registerDashObject(DashIntProperty.class);
        this.registerDashObject(DashBooleanValue.class);
        this.registerDashObject(DashDirectionValue.class);
        this.registerDashObject(DashEnumValue.class);
        this.registerDashObject(DashIntValue.class);
        this.registerDashObject(DashBitmapFont.class);
        this.registerDashObject(DashBlankFont.class);
        this.registerDashObject(DashTrueTypeFont.class);
        this.registerDashObject(DashUnicodeFont.class);
    }

    public void initAPI() {
        if (!this.initialized) {
            Instant start = Instant.now();
            this.clearAPI();
            this.initNativeAPI();
            FabricLoader.getInstance().getAllMods().parallelStream().forEach(modContainer -> {
                ModMetadata metadata = modContainer.getMetadata();
                this.processModData(metadata.getCustomValue("dashloader:customobject"), metadata);
            });
            this.sortTypes();
            LOGGER.info("[" + Duration.between(start, Instant.now()).toMillis() + "ms] Initialized api.");
            this.initialized = true;
        }
    }

    private void sortTypes() {
        this.modelTypes.sort(Comparator.comparing(Class::getSimpleName));
        this.predicateTypes.sort(Comparator.comparing(Class::getSimpleName));
        this.fontTypes.sort(Comparator.comparing(Class::getSimpleName));
        this.propertyTypes.sort(Comparator.comparing(Class::getSimpleName));
        this.propertyValueTypes.sort(Comparator.comparing(Class::getSimpleName));
    }

    private void processModData(CustomValue value, ModMetadata modMetadata) {
        if (value != null) {
            value.getAsArray().forEach(object -> {
                String dashObject = object.getAsString();
                try {
                    Class<?> aClass = Class.forName(dashObject);
                    this.registerDashObject(aClass);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Custom Dashable Object not found in mod {}. Value: {}", (Object)modMetadata.getId(), object);
                }
            });
        }
    }
}

