/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.api;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.api.ExtraVariables;
import net.oskarstrom.dashloader.api.enums.ConstructorMode;

public class FactoryConstructor {
    private final ConstructorMode constructorMode;
    private final MethodHandle constructor;

    public FactoryConstructor(ConstructorMode constructorMode, MethodHandle constructor) {
        this.constructorMode = constructorMode;
        this.constructor = constructor;
    }

    public static FactoryConstructor createConstructor(ConstructorMode mode, Class<?> dashClass, Class<?> rawClass) throws NoSuchMethodException, IllegalAccessException {
        MethodHandle constructor = MethodHandles.publicLookup().findConstructor(dashClass, MethodType.methodType(Void.TYPE, mode.getParameterGetter().apply(rawClass)));
        return new FactoryConstructor(mode, constructor);
    }

    public Object createObject(Object originalObject, DashRegistry dashRegistry, Object extraParameters1, Object extraParameters2, Object extraParameters3) {
        try {
            Object object = null;
            switch (this.constructorMode) {
                case FULL: {
                    object = this.constructor.invoke(originalObject, dashRegistry, new ExtraVariables(extraParameters1, extraParameters2, extraParameters3));
                    break;
                }
                case DEFAULT_PARAMETERS: {
                    object = this.constructor.invoke(originalObject, dashRegistry);
                    break;
                }
                case OBJECT: {
                    object = this.constructor.invoke(originalObject);
                    break;
                }
                case OBJECT_EXTRA: {
                    object = this.constructor.invoke(originalObject, new ExtraVariables(extraParameters1, extraParameters2, extraParameters3));
                    break;
                }
                case EMPTY: {
                    object = this.constructor.invoke();
                }
            }
            if (object != null) {
                return object;
            }
            DashLoader.LOGGER.error("Could not create Object from {} factory.", (Object)originalObject.getClass().getSimpleName());
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Object createObject(Object originalObject, DashRegistry dashRegistry, Object extraParameters1, Object extraParameters2) {
        return this.createObject(originalObject, dashRegistry, extraParameters1, extraParameters2, null);
    }

    public Object createObject(Object originalObject, DashRegistry dashRegistry, Object extraParameters1) {
        return this.createObject(originalObject, dashRegistry, extraParameters1, null, null);
    }

    public Object createObject(Object originalObject, DashRegistry dashRegistry) {
        return this.createObject(originalObject, dashRegistry, null, null, null);
    }
}

