/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.api.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.oskarstrom.dashloader.api.DashLoaderAPI;
import net.oskarstrom.dashloader.api.ExtraVariables;

public enum ConstructorMode {
    FULL(rawClass -> {
        ArrayList out = new ArrayList();
        out.add((Class<?>)rawClass);
        out.addAll(Arrays.stream(DashLoaderAPI.defaultParameters).toList());
        out.add(ExtraVariables.class);
        return out;
    }),
    DEFAULT_PARAMETERS(rawClass -> {
        ArrayList out = new ArrayList();
        out.add((Class<?>)rawClass);
        out.addAll(Arrays.stream(DashLoaderAPI.defaultParameters).toList());
        return out;
    }),
    OBJECT(rawClass -> {
        ArrayList<Class> out = new ArrayList<Class>();
        out.add((Class)rawClass);
        return out;
    }),
    OBJECT_EXTRA(rawClass -> {
        ArrayList<Class<ExtraVariables>> out = new ArrayList<Class<ExtraVariables>>();
        out.add((Class<ExtraVariables>)rawClass);
        out.add(ExtraVariables.class);
        return out;
    }),
    EMPTY(rawClass -> new ArrayList());

    Function<Class<?>, List<Class<?>>> parameterGetter;

    private ConstructorMode(Function<Class<?>, List<Class<?>>> parameterGetter) {
        this.parameterGetter = parameterGetter;
    }

    public Function<Class<?>, List<Class<?>>> getParameterGetter() {
        return this.parameterGetter;
    }

    public String getExpectedMethod(Class<?> dashClass, Class<?> rawClass) {
        StringBuilder expectedMethod = new StringBuilder();
        expectedMethod.append("public ");
        expectedMethod.append(dashClass.getSimpleName());
        expectedMethod.append('(');
        this.printClasses(this.parameterGetter.apply(rawClass), expectedMethod);
        expectedMethod.append(')');
        return expectedMethod.toString();
    }

    private void printClasses(List<Class<?>> classes, StringBuilder stringBuilder) {
        Iterator<Class<?>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<?> aClass = iterator.next();
            String simpleName = aClass.getSimpleName();
            stringBuilder.append(simpleName).append(' ').append(Character.toLowerCase(simpleName.charAt(0))).append(simpleName.substring(1));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
    }
}

