/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.api.feature;

import java.util.HashMap;
import java.util.Map;
import net.oskarstrom.dashloader.api.feature.Feature;

public class FeatureHandler {
    public static long data = 0L;
    public static Map<String, Feature> mixinCache;
    public static Map<String, Feature> nameCache;

    public static void init() {
        mixinCache = new HashMap<String, Feature>();
        nameCache = new HashMap<String, Feature>();
        for (Feature value : Feature.values()) {
            mixinCache.put("net.oskarstrom.dashloader.mixin.feature." + value.mixin, value);
            nameCache.put(value.name(), value);
        }
    }

    public static int calculateTasks() {
        int out = 5;
        for (Feature value : Feature.values()) {
            if (!value.active()) continue;
            out += value.tasks;
        }
        return out;
    }

    public static void disableFeature(Feature feature) {
        if (feature != null) {
            data |= 1L << feature.ordinal();
        }
    }

    public static void disableFeature(String feature) {
        FeatureHandler.disableFeature(nameCache.get(feature));
    }

    public static boolean isFeatureActive(Feature feature) {
        return (data >> feature.ordinal() & 1L) == 0L;
    }

    public static boolean active(String mixin) {
        Feature feature = mixinCache.get(mixin);
        return feature == null || feature.active();
    }
}

