/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.blockstate.property;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2754;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.api.FactoryConstructor;
import net.oskarstrom.dashloader.api.annotation.DashConstructor;
import net.oskarstrom.dashloader.api.annotation.DashObject;
import net.oskarstrom.dashloader.api.enums.ConstructorMode;
import net.oskarstrom.dashloader.blockstate.property.DashProperty;

@DashObject(value=class_2754.class)
public class DashEnumProperty
implements DashProperty {
    private static final Map<String, Class> cache = new ConcurrentHashMap<String, Class>();
    @Serialize(order=0)
    public final List<String> values;
    @Serialize(order=1)
    public final String className;
    @Serialize(order=2)
    public final String name;
    public Class<?> type;

    public DashEnumProperty(@Deserialize(value="values") List<String> values, @Deserialize(value="className") String className, @Deserialize(value="name") String name) {
        this.values = values;
        this.className = className;
        this.name = name;
    }

    @DashConstructor(value=ConstructorMode.OBJECT)
    public DashEnumProperty(class_2754 property) {
        this.className = property.method_11902().getName();
        this.name = property.method_11899();
        this.values = new ArrayList<String>();
        property.method_11898().forEach(valuee -> this.values.add(valuee.toString()));
    }

    @Override
    public class_2754<?> toUndash(DashRegistry registry) {
        return this.get();
    }

    public <T extends Enum<T>> class_2754<T> get() {
        this.type = this.getClass(this.className);
        return class_2754.method_11847((String)this.name, this.type, Arrays.asList((Enum[])this.type.getEnumConstants()));
    }

    private Class getClass(String className) {
        Class closs = cache.get(className);
        if (closs != null) {
            return closs;
        }
        try {
            Class<?> clz = Class.forName(className);
            cache.put(className, clz);
            return clz;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public FactoryConstructor overrideMethodHandleForValue() {
        return DashLoader.getInstance().getApi().propertyValueMappings.get(Enum.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashEnumProperty that = (DashEnumProperty)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.className, that.className) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.className, this.name);
    }
}

