/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.mappings;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_390;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.Dashable;
import net.oskarstrom.dashloader.data.VanillaData;
import net.oskarstrom.dashloader.data.serialization.Pointer2ObjectMap;
import net.oskarstrom.dashloader.util.ThreadHelper;

public class DashFontManagerData
implements Dashable {
    @Serialize(order=0)
    public final Pointer2ObjectMap<List<Integer>> fontMap;

    public DashFontManagerData(@Deserialize(value="fontMap") Pointer2ObjectMap<List<Integer>> fontMap) {
        this.fontMap = fontMap;
    }

    public DashFontManagerData(VanillaData data, DashRegistry registry, DashLoader.TaskHandler taskHandler) {
        this.fontMap = new Pointer2ObjectMap();
        int amount = 0;
        Map<class_2960, List<class_390>> fonts = data.getFonts();
        for (List<class_390> value : fonts.values()) {
            amount += value.size();
        }
        taskHandler.setSubtasks(amount);
        ThreadHelper.execForEach(fonts, (identifier, fontList) -> {
            ArrayList fontsOut = new ArrayList();
            fontList.forEach(font -> {
                fontsOut.add(registry.createFontPointer((class_390)font));
                taskHandler.completedSubTask();
            });
            this.fontMap.put(registry.createIdentifierPointer((class_2960)identifier), fontsOut);
        });
    }

    public Map<class_2960, List<class_390>> toUndash(DashRegistry registry) {
        HashMap<class_2960, List<class_390>> out = new HashMap<class_2960, List<class_390>>();
        this.fontMap.forEach(entry -> {
            ArrayList fontsOut = new ArrayList();
            ((List)entry.value).forEach(fontPointer -> fontsOut.add(registry.getFont((int)fontPointer)));
            out.put(registry.getIdentifier(entry.key), fontsOut);
        });
        return out;
    }
}

