/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.mappings;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_2960;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.Dashable;
import net.oskarstrom.dashloader.data.VanillaData;
import net.oskarstrom.dashloader.data.serialization.Pointer2PointerMap;
import net.oskarstrom.dashloader.util.ThreadHelper;

public class DashModelData
implements Dashable {
    @Serialize(order=0)
    public final Pointer2PointerMap models;

    public DashModelData(@Deserialize(value="models") Pointer2PointerMap models) {
        this.models = models;
    }

    public DashModelData(VanillaData data, DashRegistry registry, DashLoader.TaskHandler taskHandler) {
        Map<class_2960, class_1087> models = data.getModels();
        int size = models.size();
        this.models = new Pointer2PointerMap(size);
        taskHandler.setSubtasks(size);
        ThreadHelper.execForEach(models, (identifier, bakedModel) -> {
            if (bakedModel != null) {
                this.models.put(registry.createIdentifierPointer((class_2960)identifier), registry.createModelPointer((class_1087)bakedModel));
            }
            taskHandler.completedSubTask();
        });
    }

    public Map<class_2960, class_1087> toUndash(DashRegistry registry) {
        HashMap<class_2960, class_1087> out = new HashMap<class_2960, class_1087>();
        this.models.forEach(entry -> out.put(registry.getIdentifier(entry.key), registry.getModel(entry.value)));
        return out;
    }
}

