/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.mappings;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.Dashable;
import net.oskarstrom.dashloader.data.VanillaData;
import net.oskarstrom.dashloader.data.serialization.Pointer2ObjectMap;
import net.oskarstrom.dashloader.image.DashSpriteAtlasTexture;
import net.oskarstrom.dashloader.util.ThreadHelper;
import org.apache.commons.lang3.tuple.Pair;

public class DashParticleData
implements Dashable {
    @Serialize(order=0)
    public final Pointer2ObjectMap<List<Integer>> particles;
    @Serialize(order=1)
    public final DashSpriteAtlasTexture atlasTexture;

    public DashParticleData(@Deserialize(value="particles") Pointer2ObjectMap<List<Integer>> particles, @Deserialize(value="atlasTexture") DashSpriteAtlasTexture atlasTexture) {
        this.particles = particles;
        this.atlasTexture = atlasTexture;
    }

    public DashParticleData(VanillaData data, DashRegistry registry, DashLoader.TaskHandler taskHandler) {
        this.particles = new Pointer2ObjectMap();
        Map<class_2960, List<class_1058>> particles = data.getParticles();
        taskHandler.setSubtasks(particles.size() + 1);
        ThreadHelper.execForEach(particles, (identifier, spriteList) -> {
            ArrayList out = new ArrayList();
            spriteList.forEach(sprite -> out.add(registry.createSpritePointer((class_1058)sprite)));
            this.particles.put(registry.createIdentifierPointer((class_2960)identifier), out);
            taskHandler.completedSubTask();
        });
        class_1059 particleAtlas = data.getParticleAtlas();
        this.atlasTexture = new DashSpriteAtlasTexture(particleAtlas, data.getAtlasData(particleAtlas), registry);
        taskHandler.completedSubTask();
    }

    public Pair<Map<class_2960, List<class_1058>>, class_1059> toUndash(DashRegistry registry) {
        HashMap out = new HashMap();
        this.particles.forEach(entry -> {
            ArrayList outInner = new ArrayList();
            ((List)entry.value).forEach(integer1 -> outInner.add(registry.getSprite((int)integer1)));
            out.put(registry.getIdentifier(entry.key), outInner);
        });
        return Pair.of(out, (Object)this.atlasTexture.toUndash(registry));
    }
}

