/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.serialization;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Object2PointerMap<O> {
    @Serialize(order=0)
    public final List<Entry<O>> data;

    public Object2PointerMap(@Deserialize(value="data") List<Entry<O>> data) {
        this.data = data;
    }

    public Object2PointerMap(int size) {
        this.data = new ArrayList<Entry<O>>(size);
    }

    public Object2PointerMap(Map<O, Integer> map) {
        this.data = new ArrayList<Entry<O>>(map.size());
        map.forEach((? super K o, ? super V integer) -> this.data.add(Entry.of(o, integer)));
    }

    public Object2PointerMap() {
        this.data = new ArrayList<Entry<O>>();
    }

    public void put(O key, int value) {
        this.data.add(Entry.of(key, value));
    }

    public void forEach(Consumer<Entry<O>> action) {
        this.data.forEach(action);
    }

    public int size() {
        return this.data.size();
    }

    public Map<O, Integer> convert() {
        HashMap map = new HashMap((int)((double)this.data.size() / 0.75));
        this.data.forEach((? super T entry) -> map.put(entry.key, entry.value));
        return map;
    }

    public static class Entry<O> {
        @Serialize(order=0)
        public final O key;
        @Serialize(order=1)
        public final int value;

        public Entry(@Deserialize(value="key") O key, @Deserialize(value="value") int value) {
            this.key = key;
            this.value = value;
        }

        public static <O> Entry<O> of(O key, int value) {
            return new Entry<O>(key, value);
        }
    }
}

