/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.serialization;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;

public class PairMap<K, V> {
    @Serialize(order=0)
    public final List<Entry<K, V>> data;

    public PairMap(@Deserialize(value="data") List<Entry<K, V>> data) {
        this.data = data;
    }

    public PairMap(int size) {
        this.data = new ArrayList<Entry<K, V>>(size);
    }

    public PairMap() {
        this.data = new ArrayList<Entry<K, V>>();
    }

    public void put(K key, V value) {
        this.data.add(Entry.of(key, value));
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.data.forEach((? super T kvPairEntry) -> action.accept((Object)kvPairEntry.key, (Object)kvPairEntry.value));
    }

    public int size() {
        return this.data.size();
    }

    public static class Entry<K, V> {
        @Serialize(order=0)
        public final K key;
        @Serialize(order=1)
        public final V value;

        public Entry(@Deserialize(value="key") K key, @Deserialize(value="value") V value) {
            this.key = key;
            this.value = value;
        }

        public static <K, V> Entry<K, V> of(K key, V value) {
            return new Entry<K, V>(key, value);
        }
    }
}

