/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.serialization;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Pointer2ObjectMap<O> {
    @Serialize(order=0)
    public final List<Entry<O>> data;

    public Pointer2ObjectMap(@Deserialize(value="data") List<Entry<O>> data) {
        this.data = data;
    }

    public Pointer2ObjectMap(int size) {
        this.data = new ArrayList<Entry<O>>(size);
    }

    public Pointer2ObjectMap(Map<Integer, O> map) {
        this.data = new ArrayList<Entry<O>>(map.size());
        map.forEach((? super K integer, ? super V o) -> this.data.add(Entry.of(integer, o)));
    }

    public Pointer2ObjectMap() {
        this.data = new ArrayList<Entry<O>>();
    }

    public void put(int key, O value) {
        this.data.add(Entry.of(key, value));
    }

    public void forEach(Consumer<Entry<O>> action) {
        this.data.forEach(action);
    }

    public int size() {
        return this.data.size();
    }

    public Int2ObjectMap<O> convert() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap((int)((double)this.data.size() / 0.75));
        this.data.forEach((? super T entry) -> map.put(entry.key, entry.value));
        return map;
    }

    public static class Entry<O> {
        @Serialize(order=0)
        public final int key;
        @Serialize(order=1)
        public final O value;

        public Entry(@Deserialize(value="key") int key, @Deserialize(value="value") O value) {
            this.key = key;
            this.value = value;
        }

        public static <O> Entry<O> of(int key, O value) {
            return new Entry<O>(key, value);
        }
    }
}

