/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.serialization;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Pointer2PointerMap {
    @Serialize(order=0)
    public final List<Entry> data;

    public Pointer2PointerMap(@Deserialize(value="data") List<Entry> data) {
        this.data = data;
    }

    public Pointer2PointerMap(int size) {
        this.data = new ArrayList<Entry>(size);
    }

    public Pointer2PointerMap(Map<Integer, Integer> map) {
        this.data = new ArrayList<Entry>(map.size());
        map.forEach((? super K integer, ? super V o) -> this.data.add(Entry.of(integer, o)));
    }

    public Pointer2PointerMap() {
        this.data = new ArrayList<Entry>();
    }

    public void put(int key, int value) {
        this.data.add(Entry.of(key, value));
    }

    public void forEach(Consumer<Entry> action) {
        this.data.forEach(action);
    }

    public int size() {
        return this.data.size();
    }

    public Map<Integer, Integer> convert() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>((int)((double)this.data.size() / 0.75));
        this.data.forEach((? super T entry) -> map.put(entry.key, entry.value));
        return map;
    }

    public static class Entry {
        @Serialize(order=0)
        public final int key;
        @Serialize(order=1)
        public final int value;

        public Entry(@Deserialize(value="key") int key, @Deserialize(value="value") int value) {
            this.key = key;
            this.value = value;
        }

        public static Entry of(int key, int value) {
            return new Entry(key, value);
        }
    }
}

