/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.serializers;

import io.activej.serializer.BinarySerializer;
import io.activej.serializer.SerializerBuilder;
import io.activej.serializer.stream.StreamInput;
import io.activej.serializer.stream.StreamOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import net.oskarstrom.dashloader.DashException;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.util.ClassLoaderWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DashSerializer<O> {
    private final DashLoader loader;
    Function<SerializerBuilder, BinarySerializer<O>> createSerializerFunction;
    BinarySerializer<O> serializer;
    String identifier;
    @Nullable
    File serializerCache;

    public DashSerializer(DashLoader loader, String identifier, Function<SerializerBuilder, BinarySerializer<O>> createSerializerFunction) {
        this.createSerializerFunction = createSerializerFunction;
        this.identifier = identifier;
        this.loader = loader;
    }

    public boolean createSerializer(boolean forceRecache) {
        block8: {
            if (!forceRecache) {
                Path serializerPath = this.getSerializerPath(this.identifier);
                if (serializerPath != null) {
                    try {
                        File serializerFile = serializerPath.toFile();
                        if (serializerFile.exists()) {
                            this.serializerCache = serializerFile;
                            this.serializer = this.loadSerializerCache(DashLoader.getInstance().getAssignedClassLoader(), serializerFile);
                            return true;
                        }
                    }
                    catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    BinarySerializer<O> build = this.createSerializerFunction.apply(SerializerBuilder.create().withGeneratedBytecodePath(this.loader.getModBoundDir()));
                    this.renameRawSerializer(this.identifier, build);
                    this.serializer = build;
                }
                catch (IOException e) {
                    if (e instanceof FileSystemException) break block8;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public void serializeObject(O clazz, Path path, String name) {
        DashLoader.TaskHandler taskHandler = DashLoader.TASK_HANDLER;
        try {
            taskHandler.setCurrentTask("Serializing " + name);
            taskHandler.setSubtasks(3);
            DashLoader.LOGGER.info("  Starting " + name + " Serialization.");
            StreamOutput output = StreamOutput.create((OutputStream)Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE));
            taskHandler.completedSubTask();
            output.serialize(this.serializer, clazz);
            taskHandler.completedSubTask();
            output.close();
            taskHandler.completedSubTask();
            DashLoader.LOGGER.info("    Finished " + name + " Serialization.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        taskHandler.completedTask();
    }

    @NotNull
    public O deserializeObject(Path path, String name) {
        try {
            if (this.serializer == null) {
                throw new DashException(name + " Serializer not created.");
            }
            Object out = StreamInput.create((InputStream)Files.newInputStream(path, new OpenOption[0]), (int)0x100000).deserialize(this.serializer);
            if (out == null) {
                throw new DashException(name + " Deserialization failed");
            }
            return (O)out;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DashException(name + " File failed");
        }
    }

    private <K> BinarySerializer<K> loadSerializerCache(ClassLoaderWrapper classLoader, File serializer) throws IOException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        byte[] bytes = IOUtils.toByteArray((InputStream)FileUtils.openInputStream((File)serializer));
        return this.createSerializerInstance(classLoader, "io.activej.codegen.io.activej.serializer.BinarySerializer_" + serializer.getName().split("-")[0], bytes);
    }

    private <T> BinarySerializer<T> createSerializerInstance(ClassLoaderWrapper classLoader, String actualClassName, byte[] bytecode) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> aClass = classLoader.defineCustomClass(actualClassName, bytecode);
        try {
            Field field = aClass.getField("$GENERATED");
            field.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        return (BinarySerializer)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Path getSerializerPath(String name) {
        File[] files = this.loader.getModBoundDir().toFile().listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!file.getName().endsWith(name + ".serializer")) continue;
            return Paths.get(file.toURI());
        }
        return null;
    }

    public void markCacheAsNull() {
        this.serializerCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K> void renameRawSerializer(String name, BinarySerializer<K> serializer) throws IOException {
        String className = serializer.getClass().getName().replaceFirst("io.activej.codegen.", "");
        Path folder = this.loader.getModBoundDir();
        Path rawSerializerPath = folder.resolve(className + ".class");
        Path destination = folder.resolve(className.replaceFirst("io.activej.serializer.BinarySerializer_", "") + "-" + name + ".serializer");
        try {
            Files.move(rawSerializerPath, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(rawSerializerPath);
        }
        DashLoader.LOGGER.info("Created Serializer {}", (Object)className);
    }
}

