/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.data.serializers;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashMappings;
import net.oskarstrom.dashloader.api.DashLoaderAPI;
import net.oskarstrom.dashloader.data.DashRegistryData;
import net.oskarstrom.dashloader.data.registry.RegistryImageData;
import net.oskarstrom.dashloader.data.registry.RegistryModelData;
import net.oskarstrom.dashloader.data.serializers.DashSerializer;
import net.oskarstrom.dashloader.util.TimeHelper;

public class DashSerializers {
    public static final List<DashSerializer<?>> SERIALIZERS = new ArrayList();
    public static final DashSerializer<DashRegistryData> REGISTRY_SERIALIZER;
    public static final DashSerializer<DashMappings> MAPPING_SERIALIZER;
    public static final DashSerializer<RegistryModelData> MODEL_SERIALIZER;
    public static final DashSerializer<RegistryImageData> IMAGE_SERIALIZER;

    private static <O> DashSerializer<O> addSerializer(DashSerializer<O> serializer) {
        SERIALIZERS.add(serializer);
        return serializer;
    }

    public static void initSerializers() {
        Instant start = Instant.now();
        if (!DashSerializers.createSerializers(false)) {
            DashSerializers.clearSerializers();
            DashSerializers.createSerializers(true);
        }
        DashLoader.LOGGER.info("[{}ms] Initialized Serializers", (Object)TimeHelper.getMs(start));
    }

    private static boolean createSerializers(boolean forceRecache) {
        for (DashSerializer<?> serializer : SERIALIZERS) {
            if (serializer.createSerializer(forceRecache) || forceRecache) continue;
            return false;
        }
        return true;
    }

    public static void clearSerializers() {
        for (DashSerializer<?> serializer : SERIALIZERS) {
            serializer.markCacheAsNull();
        }
    }

    static {
        DashLoader loader = DashLoader.getInstance();
        REGISTRY_SERIALIZER = DashSerializers.addSerializer(new DashSerializer(loader, "registry", builder -> {
            DashLoaderAPI api = loader.getApi();
            api.initAPI();
            return builder.withSubclasses("fonts", api.fontTypes).withSubclasses("predicates", api.predicateTypes).withSubclasses("properties", api.propertyTypes).withSubclasses("values", api.propertyValueTypes).build(DashRegistryData.class);
        }));
        MODEL_SERIALIZER = DashSerializers.addSerializer(new DashSerializer(loader, "model", builder -> {
            DashLoaderAPI api = loader.getApi();
            api.initAPI();
            return builder.withSubclasses("models", api.modelTypes).build(RegistryModelData.class);
        }));
        IMAGE_SERIALIZER = DashSerializers.addSerializer(new DashSerializer(loader, "image", builder -> builder.build(RegistryImageData.class)));
        MAPPING_SERIALIZER = DashSerializers.addSerializer(new DashSerializer(loader, "mapping", builder -> builder.build(DashMappings.class)));
    }
}

