/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.font;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_395;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.api.annotation.DashConstructor;
import net.oskarstrom.dashloader.api.annotation.DashObject;
import net.oskarstrom.dashloader.api.enums.ConstructorMode;
import net.oskarstrom.dashloader.font.DashFont;
import net.oskarstrom.dashloader.mixin.accessor.TrueTypeFontAccessor;
import net.oskarstrom.dashloader.util.IOHelper;
import net.oskarstrom.dashloader.util.UnsafeHelper;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;

@DashObject(value=class_395.class)
public class DashTrueTypeFont
implements DashFont {
    @Serialize(order=0)
    public final byte[] ttfBuffer;
    @Serialize(order=1)
    public final float oversample;
    @Serialize(order=2)
    public final Set<Integer> excludedCharacters;
    @Serialize(order=3)
    public final float shiftX;
    @Serialize(order=4)
    public final float shiftY;
    @Serialize(order=5)
    public final float scaleFactor;
    @Serialize(order=6)
    public final float ascent;

    public DashTrueTypeFont(@Deserialize(value="ttfBuffer") byte[] ttfBuffer, @Deserialize(value="oversample") float oversample, @Deserialize(value="excludedCharacters") Set<Integer> excludedCharacters, @Deserialize(value="shiftX") float shiftX, @Deserialize(value="shiftY") float shiftY, @Deserialize(value="scaleFactor") float scaleFactor, @Deserialize(value="ascent") float ascent) {
        this.ttfBuffer = ttfBuffer;
        this.oversample = oversample;
        this.excludedCharacters = excludedCharacters;
        this.shiftX = shiftX;
        this.shiftY = shiftY;
        this.scaleFactor = scaleFactor;
        this.ascent = ascent;
    }

    @DashConstructor(value=ConstructorMode.OBJECT)
    public DashTrueTypeFont(class_395 font) {
        TrueTypeFontAccessor fontAccess = (TrueTypeFontAccessor)font;
        Object2ObjectMap<STBTTFontinfo, class_2960> fontData = DashLoader.getVanillaData().getFontData();
        byte[] data = null;
        try {
            class_3298 resource = class_310.method_1551().method_1478().method_14486(new class_2960(((class_2960)fontData.get((Object)fontAccess.getInfo())).method_12836(), "font/" + ((class_2960)fontData.get((Object)fontAccess.getInfo())).method_12832()));
            data = IOHelper.streamToArray(resource.method_14482());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.ttfBuffer = data;
        this.oversample = fontAccess.getOversample();
        this.excludedCharacters = fontAccess.getExcludedCharacters();
        this.shiftX = fontAccess.getShiftX();
        this.shiftY = fontAccess.getShiftY();
        this.scaleFactor = fontAccess.getScaleFactor();
        this.ascent = fontAccess.getAscent();
    }

    @Override
    public class_395 toUndash(DashRegistry registry) {
        STBTTFontinfo sTBTTFontinfo = STBTTFontinfo.malloc();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.ttfBuffer.length);
        byteBuffer2.put(this.ttfBuffer);
        byteBuffer2.flip();
        if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)sTBTTFontinfo, (ByteBuffer)byteBuffer2)) {
            try {
                throw new IOException("Invalid ttf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        class_395 trueTypeFont = UnsafeHelper.allocateInstance(class_395.class);
        TrueTypeFontAccessor trueTypeFontAccess = (TrueTypeFontAccessor)trueTypeFont;
        trueTypeFontAccess.setInfo(sTBTTFontinfo);
        trueTypeFontAccess.setOversample(this.oversample);
        trueTypeFontAccess.setBuffer(byteBuffer2);
        trueTypeFontAccess.setExcludedCharacters((IntSet)new IntArraySet(this.excludedCharacters));
        trueTypeFontAccess.setShiftX(this.shiftX);
        trueTypeFontAccess.setShiftY(this.shiftY);
        trueTypeFontAccess.setScaleFactor(this.scaleFactor);
        trueTypeFontAccess.setAscent(this.ascent);
        return trueTypeFont;
    }
}

