/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.image;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.class_1011;
import net.oskarstrom.dashloader.DashException;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.Dashable;
import net.oskarstrom.dashloader.mixin.accessor.NativeImageAccessor;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class DashImage
implements Dashable<class_1011> {
    @Serialize(order=0)
    public final byte[] image;
    @Serialize(order=1)
    public final class_1011.class_1012 format;
    @Serialize(order=2)
    public final boolean useSTB;
    @Serialize(order=3)
    public final int width;
    @Serialize(order=4)
    public final int height;

    public DashImage(class_1011 nativeImage) {
        try {
            NativeImageAccessor nativeImageAccess = (NativeImageAccessor)nativeImage;
            this.format = nativeImage.method_4318();
            this.width = nativeImage.method_4307();
            this.height = nativeImage.method_4323();
            this.image = nativeImage.method_24036();
            this.useSTB = nativeImageAccess.getIsStbImage();
        }
        catch (IOException e) {
            throw new DashException("Failed to create image. Reason: ", e);
        }
    }

    public DashImage(@Deserialize(value="image") byte[] image, @Deserialize(value="format") class_1011.class_1012 format, @Deserialize(value="useSTB") boolean useSTB, @Deserialize(value="width") int width, @Deserialize(value="height") int height) {
        this.image = image;
        this.format = format;
        this.useSTB = useSTB;
        this.width = width;
        this.height = height;
    }

    @Override
    public final class_1011 toUndash(DashRegistry registry) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer buf = ByteBuffer.allocateDirect(this.image.length);
            buf.put(this.image);
            buf.flip();
            long pointer = STBImage.nstbi_load_from_memory((long)MemoryUtil.memAddress((ByteBuffer)buf), (int)buf.remaining(), (long)stack.nmalloc(4, 4), (long)stack.nmalloc(4, 4), (long)stack.nmalloc(4, 4), (int)this.format.method_4335());
            if (pointer == 0L) {
                throw new DashException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            class_1011 class_10112 = NativeImageAccessor.init(this.format, this.width, this.height, this.useSTB, pointer);
            return class_10112;
        }
    }
}

