/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.image;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1061;
import net.minecraft.class_2960;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.data.serialization.Pointer2PointerMap;
import net.oskarstrom.dashloader.image.DashSpriteAtlasTextureData;
import net.oskarstrom.dashloader.mixin.accessor.AbstractTextureAccessor;
import net.oskarstrom.dashloader.mixin.accessor.SpriteAccessor;
import net.oskarstrom.dashloader.mixin.accessor.SpriteAtlasTextureAccessor;
import net.oskarstrom.dashloader.util.UnsafeHelper;

public class DashSpriteAtlasTexture {
    @Serialize(order=0)
    public final int id;
    @Serialize(order=1)
    public final int maxTextureSize;
    @Serialize(order=2)
    public Pointer2PointerMap sprites;
    @Serialize(order=3)
    public boolean bilinear;
    @Serialize(order=4)
    public boolean mipmap;
    @Serialize(order=5)
    public DashSpriteAtlasTextureData data;

    public DashSpriteAtlasTexture(@Deserialize(value="id") int id, @Deserialize(value="maxTextureSize") int maxTextureSize, @Deserialize(value="sprites") Pointer2PointerMap sprites, @Deserialize(value="bilinear") boolean bilinear, @Deserialize(value="mipmap") boolean mipmap, @Deserialize(value="data") DashSpriteAtlasTextureData data) {
        this.id = id;
        this.maxTextureSize = maxTextureSize;
        this.sprites = sprites;
        this.bilinear = bilinear;
        this.mipmap = mipmap;
        this.data = data;
    }

    public DashSpriteAtlasTexture(class_1059 spriteAtlasTexture, DashSpriteAtlasTextureData data, DashRegistry registry) {
        SpriteAtlasTextureAccessor spriteTextureAccess = (SpriteAtlasTextureAccessor)spriteAtlasTexture;
        this.data = data;
        this.sprites = new Pointer2PointerMap();
        spriteTextureAccess.getSprites().forEach((identifier, sprite) -> this.sprites.put(registry.createIdentifierPointer((class_2960)identifier), registry.createSpritePointer((class_1058)sprite)));
        this.id = registry.createIdentifierPointer(spriteAtlasTexture.method_24106());
        this.maxTextureSize = spriteTextureAccess.getMaxTextureSize();
        this.bilinear = ((AbstractTextureAccessor)spriteAtlasTexture).getBilinear();
        this.mipmap = ((AbstractTextureAccessor)spriteAtlasTexture).getMipmap();
    }

    public class_1059 toUndash(DashRegistry registry) {
        class_1059 spriteAtlasTexture = UnsafeHelper.allocateInstance(class_1059.class);
        AbstractTextureAccessor access = (AbstractTextureAccessor)spriteAtlasTexture;
        access.setBilinear(this.bilinear);
        access.setMipmap(this.mipmap);
        SpriteAtlasTextureAccessor spriteAtlasTextureAccessor = (SpriteAtlasTextureAccessor)spriteAtlasTexture;
        HashMap<class_2960, class_1058> out = new HashMap<class_2960, class_1058>(this.sprites.size());
        this.sprites.forEach(entry -> out.put(registry.getIdentifier(entry.key), this.loadSprite(entry.value, registry, spriteAtlasTexture)));
        ArrayList<class_1061> outAnimatedSprites = new ArrayList<class_1061>();
        out.values().forEach(sprite -> {
            class_1061 animation = sprite.method_33443();
            if (animation != null) {
                outAnimatedSprites.add(animation);
            }
        });
        spriteAtlasTextureAccessor.setAnimatedSprites(outAnimatedSprites);
        spriteAtlasTextureAccessor.setSpritesToLoad(new HashSet<class_2960>());
        spriteAtlasTextureAccessor.setSprites(out);
        spriteAtlasTextureAccessor.setId(registry.getIdentifier(this.id));
        spriteAtlasTextureAccessor.setMaxTextureSize(this.maxTextureSize);
        DashLoader.getVanillaData().addAtlasData(spriteAtlasTexture, this.data);
        return spriteAtlasTexture;
    }

    private class_1058 loadSprite(int spritePointer, DashRegistry registry, class_1059 spriteAtlasTexture) {
        class_1058 sprite = registry.getSprite(spritePointer);
        ((SpriteAccessor)sprite).setAtlas(spriteAtlasTexture);
        return sprite;
    }
}

