/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.mixin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.api.DashConfig;
import net.oskarstrom.dashloader.api.feature.Feature;
import net.oskarstrom.dashloader.api.feature.FeatureHandler;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;

public class MixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        FeatureHandler.init();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata metadata = mod.getMetadata();
            if (!metadata.containsCustomValue("dashloader:disablefeature")) continue;
            CustomValue customValue = metadata.getCustomValue("dashloader:disablefeature");
            customValue.getAsArray().forEach(value -> {
                String feature = value.getAsString();
                FeatureHandler.disableFeature(feature);
                DashLoader.LOGGER.warn("Disabled " + feature + " feature from mod: " + metadata.getName());
            });
        }
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        Path resolve = DashLoader.getConfig().resolve("dashloader.yaml");
        if (Files.exists(resolve, new LinkOption[0])) {
            try {
                resolve.toFile().setReadable(true);
                DashConfig dashConfig = (DashConfig)yaml.loadAs((InputStream)FileUtils.openInputStream((File)resolve.toFile()), DashConfig.class);
                for (Feature feature : dashConfig.getDisabledFeatures()) {
                    FeatureHandler.disableFeature(feature);
                    DashLoader.LOGGER.error("Disabled " + feature + " feature from config");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                resolve.toFile().setWritable(true);
                Files.createFile(resolve, new FileAttribute[0]);
                DashConfig data = new DashConfig(new Feature[0]);
                Files.writeString(resolve, (CharSequence)yaml.dumpAs((Object)data, Tag.MAP, null), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return FeatureHandler.active(mixinClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

