/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.model;

import io.activej.serializer.annotations.Deserialize;
import io.activej.serializer.annotations.Serialize;
import io.activej.serializer.annotations.SerializeNullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1093;
import net.minecraft.class_2350;
import net.minecraft.class_777;
import net.minecraft.class_809;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.api.annotation.DashObject;
import net.oskarstrom.dashloader.data.DashDirection;
import net.oskarstrom.dashloader.data.serialization.PairMap;
import net.oskarstrom.dashloader.mixin.accessor.BasicBakedModelAccessor;
import net.oskarstrom.dashloader.model.DashModel;
import net.oskarstrom.dashloader.model.components.DashBakedQuad;
import net.oskarstrom.dashloader.model.components.DashModelOverrideList;
import net.oskarstrom.dashloader.model.components.DashModelTransformation;
import net.oskarstrom.dashloader.util.DashHelper;
import org.apache.commons.lang3.tuple.Pair;

@DashObject(value=class_1093.class)
public class DashBasicBakedModel
implements DashModel {
    @Serialize(order=0)
    public final List<DashBakedQuad> quads;
    @Serialize(order=1)
    public final PairMap<DashDirection, List<DashBakedQuad>> faceQuads;
    @Serialize(order=2)
    public final boolean usesAo;
    @Serialize(order=3)
    public final boolean hasDepth;
    @Serialize(order=4)
    public final boolean isSideLit;
    @Serialize(order=5)
    @SerializeNullable
    public final DashModelTransformation transformation;
    @Serialize(order=6)
    public final DashModelOverrideList itemPropertyOverrides;
    @Serialize(order=7)
    public final int spritePointer;

    public DashBasicBakedModel(@Deserialize(value="quads") List<DashBakedQuad> quads, @Deserialize(value="faceQuads") PairMap<DashDirection, List<DashBakedQuad>> faceQuads, @Deserialize(value="usesAo") boolean usesAo, @Deserialize(value="hasDepth") boolean hasDepth, @Deserialize(value="isSideLit") boolean isSideLit, @Deserialize(value="transformation") DashModelTransformation transformation, @Deserialize(value="itemPropertyOverrides") DashModelOverrideList itemPropertyOverrides, @Deserialize(value="spritePointer") int spritePointer) {
        this.quads = quads;
        this.faceQuads = faceQuads;
        this.usesAo = usesAo;
        this.hasDepth = hasDepth;
        this.isSideLit = isSideLit;
        this.transformation = transformation;
        this.itemPropertyOverrides = itemPropertyOverrides;
        this.spritePointer = spritePointer;
    }

    public DashBasicBakedModel(class_1093 basicBakedModel, DashRegistry registry) {
        BasicBakedModelAccessor access = (BasicBakedModelAccessor)basicBakedModel;
        this.quads = new ArrayList<DashBakedQuad>();
        access.getQuads().forEach(bakedQuad -> this.quads.add(new DashBakedQuad((class_777)bakedQuad)));
        Map<class_2350, List<class_777>> faceQuads = access.getFaceQuads();
        this.faceQuads = DashHelper.convertMapToPM(faceQuads, (direction, bakedQuads) -> Pair.of((Object)new DashDirection((class_2350)direction), DashHelper.convertList(bakedQuads, DashBakedQuad::new)));
        this.itemPropertyOverrides = new DashModelOverrideList(access.getItemPropertyOverrides(), registry);
        this.usesAo = access.getUsesAo();
        this.hasDepth = access.getHasDepth();
        this.isSideLit = access.getIsSideLit();
        class_809 transformation = access.getTransformation();
        this.transformation = transformation == class_809.field_4301 ? null : DashModelTransformation.createDashModelTransformation(transformation);
        this.spritePointer = registry.createSpritePointer(access.getSprite());
    }

    @Override
    public class_1093 toUndash(DashRegistry registry) {
        class_1058 sprite = registry.getSprite(this.spritePointer);
        List<class_777> quadsOut = DashHelper.convertList(this.quads, dashBakedQuad -> dashBakedQuad.toUndash(sprite, registry));
        Map faceQuadsOut = DashHelper.convertPairMapToMap(this.faceQuads, (dashDirection, dashBakedQuads) -> Pair.of((Object)dashDirection.toUndash(registry), DashHelper.convertList(dashBakedQuads, dashBakedQuad -> dashBakedQuad.toUndash(sprite, registry))));
        return new class_1093(quadsOut, faceQuadsOut, this.usesAo, this.isSideLit, this.hasDepth, sprite, this.transformation == null ? class_809.field_4301 : this.transformation.toUndash(), this.itemPropertyOverrides.toUndash(registry));
    }

    @Override
    public void apply(DashRegistry registry) {
        this.itemPropertyOverrides.applyOverrides(registry);
    }

    @Override
    public int getStage() {
        return 0;
    }
}

