/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.util;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import net.oskarstrom.dashloader.util.TimeHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DashReport {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<Entry> entries = new ArrayList<Entry>();
    private static final List<Pair<Instant, String>> times = new ArrayList<Pair<Instant, String>>();
    private static final int BARSIZE = 60;
    private static final char BARCHAR = '*';

    public static void addEntry(Entry entry) {
        entries.add(entry);
    }

    public static void addTime(Instant time, String text) {
        times.add((Pair<Instant, String>)Pair.of((Object)time, (Object)text));
    }

    public static void printReport() {
        DashReport.printBorder("Minecraft Samples");
        ArrayList<Entry> dashEntries = new ArrayList<Entry>();
        for (Entry entry : entries) {
            if (!entry.dashReport) {
                DashReport.printEntry(entry);
                continue;
            }
            dashEntries.add(entry);
        }
        DashReport.printBorder("DashLoader Samples");
        for (Entry dashEntry : dashEntries) {
            DashReport.printEntry(dashEntry);
        }
        DashReport.printBorder("Launch Time");
        DashReport.printLaunch();
        DashReport.printBorder("DashReport End");
    }

    private static void printLaunch() {
        Instant stop = Instant.now();
        for (Pair<Instant, String> time : times) {
            LOGGER.info("--- [{}] {}", (Object)TimeHelper.smartGetTime((Instant)time.getLeft(), stop), time.getRight());
        }
    }

    private static void printBorder(String text) {
        String border = DashReport.getBorder(text.length());
        LOGGER.info("{}[{}]{}", (Object)border, (Object)text, (Object)border);
    }

    public static String getBorder(int textLength) {
        return String.valueOf('*').repeat(Math.max(0, Math.round((float)(60 - textLength) / 2.0f)));
    }

    private static void printEntry(Entry entry) {
        LOGGER.info("--- [{}] {}", (Object)TimeHelper.smartGetTime(entry.start, entry.stop), (Object)entry.name);
    }

    public static class Entry {
        Instant start;
        Instant stop;
        String name;
        boolean dashReport;

        public Entry(Instant start, String name, boolean dashReport) {
            this.start = start;
            this.stop = Instant.now();
            this.name = name;
            this.dashReport = dashReport;
        }
    }
}

