/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.oskarstrom.dashloader.DashLoader;
import net.oskarstrom.dashloader.DashRegistry;
import net.oskarstrom.dashloader.Dashable;
import net.oskarstrom.dashloader.data.serialization.Pointer2ObjectMap;
import net.oskarstrom.dashloader.model.DashModel;
import org.apache.commons.lang3.tuple.Pair;

public class ThreadHelper {
    public static void exec(Runnable ... runnables) {
        ThreadHelper.exec(Arrays.stream(runnables).map(Executors::callable).collect(Collectors.toList()));
    }

    public static <T> void exec(List<Callable<T>> callable) {
        List futures = DashLoader.THREAD_POOL.invokeAll(callable);
        ThreadHelper.sleepUntilTrue(() -> futures.stream().allMatch(Future::isDone));
    }

    public static <K, V> void execForEach(Map<K, V> map, BiConsumer<K, V> consumer) {
        map.forEach(consumer);
    }

    public static <V> void execForEach(Collection<V> map, Consumer<V> consumer) {
        map.forEach(consumer);
    }

    public static <D extends Dashable<R>, R> Int2ObjectMap<R> execParallel(Int2ObjectMap<D> dashables, DashRegistry registry) {
        Int2ObjectOpenHashMap answerMap = new Int2ObjectOpenHashMap((int)Math.ceil((double)dashables.size() / 0.75));
        UndashTask task = new UndashTask(new ArrayList(dashables.int2ObjectEntrySet()), 100, registry);
        ArrayList invoke = (ArrayList)DashLoader.THREAD_POOL.invoke(task);
        invoke.forEach(arg_0 -> ThreadHelper.lambda$execParallel$1((Int2ObjectMap)answerMap, arg_0));
        return answerMap;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void sleepUntilTrue(Supplier<Boolean> supplier) {
        while (!supplier.get().booleanValue()) {
            ThreadHelper.sleep(10L);
        }
    }

    public static void sleepUntilFalse(Supplier<Boolean> supplier) {
        while (supplier.get().booleanValue()) {
            ThreadHelper.sleep(10L);
        }
    }

    public static void sleepUntilTrue(Supplier<Boolean> supplier, long millis) {
        while (!supplier.get().booleanValue()) {
            ThreadHelper.sleep(millis);
        }
    }

    public static void sleepUntilFalse(Supplier<Boolean> supplier, long millis) {
        while (supplier.get().booleanValue()) {
            ThreadHelper.sleep(millis);
        }
    }

    private static /* synthetic */ void lambda$execParallel$1(Int2ObjectMap answerMap, Pointer2ObjectMap.Entry answer) {
        answerMap.put(answer.key, answer.value);
    }

    public static class UndashTask<R, D extends Dashable<R>>
    extends RecursiveTask<ArrayList<Pointer2ObjectMap.Entry<R>>> {
        private final List<Int2ObjectMap.Entry<D>> tasks;
        private final int threshold;
        private final DashRegistry registry;

        public UndashTask(List<Int2ObjectMap.Entry<D>> tasks, int threshold, DashRegistry registry) {
            this.tasks = tasks;
            this.threshold = threshold;
            this.registry = registry;
        }

        @Override
        protected ArrayList<Pointer2ObjectMap.Entry<R>> compute() {
            int size = this.tasks.size();
            if (size < this.threshold) {
                return this.computeDirectly();
            }
            int half = size / 2;
            UndashTask<R, D> first = new UndashTask<R, D>(this.tasks.subList(0, half), this.threshold, this.registry);
            UndashTask<R, D> second = new UndashTask<R, D>(this.tasks.subList(half, size), this.threshold, this.registry);
            UndashTask.invokeAll(first, second);
            Throwable exception = first.getException();
            Throwable exception1 = second.getException();
            if (exception != null) {
                DashLoader.LOGGER.fatal("Thread failed. Reason: ", exception);
            }
            if (exception1 != null) {
                DashLoader.LOGGER.fatal("Thread failed. Reason: ", exception1);
            }
            return this.combine((ArrayList)first.join(), (ArrayList)second.join());
        }

        public final ArrayList<Pointer2ObjectMap.Entry<R>> combine(ArrayList<Pointer2ObjectMap.Entry<R>> list, ArrayList<Pointer2ObjectMap.Entry<R>> list2) {
            list.ensureCapacity(list.size() * 2);
            list.addAll(list2);
            return list;
        }

        protected final ArrayList<Pointer2ObjectMap.Entry<R>> computeDirectly() {
            ArrayList<Pointer2ObjectMap.Entry<R>> count = new ArrayList<Pointer2ObjectMap.Entry<R>>(this.tasks.size());
            this.tasks.forEach(dashable -> {
                Pointer2ObjectMap.Entry oEntry = new Pointer2ObjectMap.Entry(dashable.getIntKey(), ((Dashable)dashable.getValue()).toUndash(this.registry));
                count.add(oEntry);
            });
            return count;
        }

        public static class ApplyTask
        extends RecursiveAction {
            final List<DashModel> tasks;
            final int threshold;
            final DashRegistry registry;

            public ApplyTask(List<DashModel> tasks, int threshold, DashRegistry registry) {
                this.tasks = tasks;
                this.threshold = threshold;
                this.registry = registry;
            }

            public final Pair<List<DashModel>, List<DashModel>> split(List<DashModel> list, int size) {
                int i;
                ArrayList<DashModel> first = new ArrayList<DashModel>();
                ArrayList<DashModel> second = new ArrayList<DashModel>();
                int i1 = size / 2;
                for (i = 0; i < i1; ++i) {
                    first.add(list.get(i));
                }
                for (i = i1; i < size; ++i) {
                    second.add(list.get(i));
                }
                return Pair.of(first, second);
            }

            @Override
            protected void compute() {
                int size = this.tasks.size();
                if (size < this.threshold) {
                    this.computeDirectly();
                } else {
                    Pair<List<DashModel>, List<DashModel>> subtask = this.split(this.tasks, size);
                    ApplyTask subTask1 = new ApplyTask((List)subtask.getKey(), this.threshold, this.registry);
                    ApplyTask subTask2 = new ApplyTask((List)subtask.getValue(), this.threshold, this.registry);
                    ApplyTask.invokeAll(subTask1, subTask2);
                }
            }

            protected void computeDirectly() {
                this.tasks.forEach(dashable -> dashable.apply(this.registry));
            }
        }
    }
}

