/*
 * Decompiled with CFR 0.152.
 */
package net.oskarstrom.dashloader.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;

public class UnsafeHelper {
    private static final MethodHandle allocateInstance;

    public static <O> O allocateInstance(Class<O> closs) {
        try {
            return (O)allocateInstance.invokeExact(closs);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static Object getUnsafe(Class<?> unsafeClass) throws ClassNotFoundException, IllegalAccessException {
        int mods = 26;
        for (Field field : unsafeClass.getDeclaredFields()) {
            if (field.getModifiers() != 26 || field.getType() != unsafeClass) continue;
            field.setAccessible(true);
            Object possibleUnsafe = field.get(null);
            if (possibleUnsafe == null) continue;
            return possibleUnsafe;
        }
        throw new RuntimeException("Unable to find Sun UnsafeHelper Library.");
    }

    static {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            allocateInstance = MethodHandles.lookup().findVirtual(unsafeClass, "allocateInstance", MethodType.methodType(Object.class, Class.class)).bindTo(UnsafeHelper.getUnsafe(unsafeClass));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Unable to bind AllocateInstance.");
        }
    }
}

