/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.dispenserbazooka.item;

import com.google.common.collect.ImmutableList;
import com.ibarnstormer.dispenserbazooka.Main;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class DispenserBazooka
extends Item {
    private final HashMap<Item, Integer> BEHAVIORS = new HashMap();

    public DispenserBazooka() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(1).m_41486_().m_41491_(CreativeModeTab.f_40753_));
        this.BEHAVIORS.put(Items.f_42679_, 0);
        this.BEHAVIORS.put(Items.f_42613_, 1);
        this.BEHAVIORS.put(Items.f_42688_, 2);
        this.BEHAVIORS.put(Items.f_42412_, 3);
        this.BEHAVIORS.put(Items.f_42738_, 3);
        this.BEHAVIORS.put(Items.f_42737_, 3);
        this.BEHAVIORS.put(Items.f_42736_, 4);
        this.BEHAVIORS.put(Items.f_42739_, 4);
        this.BEHAVIORS.put(Items.f_42521_, 5);
        this.BEHAVIORS.put(Items.f_42452_, 6);
        this.BEHAVIORS.put(Items.f_42584_, 7);
        this.BEHAVIORS.put(Items.f_42612_, 8);
        this.BEHAVIORS.put(Items.f_41996_, 9);
        this.BEHAVIORS.put(Items.f_42713_, 10);
        ImmutableList allItems = ImmutableList.copyOf((Collection)ForgeRegistries.ITEMS.getValues());
        for (Item i : allItems) {
            if (this.BEHAVIORS.containsKey(i)) continue;
            if (i instanceof ArrowItem) {
                this.BEHAVIORS.put(i, 3);
                Main.LOGGER.debug("Successfully registered " + i.getRegistryName() + " as a valid third party mod ammunition item for the Dispenser Bazooka");
                continue;
            }
            if (!(i instanceof ThrowablePotionItem)) continue;
            this.BEHAVIORS.put(i, 4);
            Main.LOGGER.debug("Successfully registered " + i.getRegistryName() + " as a valid third party mod ammunition item for the Dispenser Bazooka");
        }
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_77661_1_) {
        return UseAnim.BOW;
    }

    public void m_5551_(ItemStack item, Level worldIn, LivingEntity entity, int p_77615_4_) {
        Player entityIn = (Player)entity;
        if (!worldIn.f_46443_) {
            boolean flag = false;
            for (ItemStack itemStack : entityIn.m_150109_().f_35974_) {
                if (!flag) {
                    boolean bl = flag = itemStack == item;
                }
                if (entityIn.m_150109_().f_35976_.contains((Object)item)) {
                    flag = true;
                }
                if (itemStack == item || itemStack.m_41619_() || !flag || entityIn.m_150109_().m_36056_() == itemStack) continue;
                Item type = itemStack.m_41720_();
                if (this.BEHAVIORS.containsKey(type)) {
                    switch (this.BEHAVIORS.get(type)) {
                        case 0: {
                            this.launchExplosiveProjectile(worldIn, entityIn, (AbstractHurtingProjectile)new WitherSkull(worldIn, (LivingEntity)entityIn, entityIn.m_20154_().f_82479_, entityIn.m_20154_().f_82480_, entityIn.m_20154_().f_82481_));
                            break;
                        }
                        case 1: {
                            this.launchExplosiveProjectile(worldIn, entityIn, (AbstractHurtingProjectile)new SmallFireball(worldIn, (LivingEntity)entityIn, entityIn.m_20154_().f_82479_, entityIn.m_20154_().f_82480_, entityIn.m_20154_().f_82481_));
                            break;
                        }
                        case 2: {
                            this.launchFirework(worldIn, entityIn, new FireworkRocketEntity(worldIn, itemStack, (Entity)entityIn, entityIn.m_20185_(), entityIn.m_20188_(), entityIn.m_20189_(), true));
                            break;
                        }
                        case 3: {
                            this.launchArrow(worldIn, entityIn, ((ArrowItem)itemStack.m_41720_()).m_6394_(worldIn, itemStack, (LivingEntity)entityIn));
                            break;
                        }
                        case 4: {
                            this.launchPotion(worldIn, entityIn, itemStack, new ThrownPotion(worldIn, (LivingEntity)entityIn));
                            break;
                        }
                        case 5: {
                            this.launchEgg(worldIn, entityIn, itemStack, new ThrownEgg(worldIn, (LivingEntity)entityIn));
                            break;
                        }
                        case 6: {
                            this.launchSnowball(worldIn, entityIn, itemStack, new Snowball(worldIn, (LivingEntity)entityIn));
                            break;
                        }
                        case 7: {
                            this.launchEnderPearl(worldIn, entityIn, itemStack, new ThrownEnderpearl(worldIn, (LivingEntity)entityIn));
                            break;
                        }
                        case 8: {
                            this.launchXPBottle(worldIn, entityIn, itemStack, new ThrownExperienceBottle(worldIn, (LivingEntity)entityIn));
                            break;
                        }
                        case 9: {
                            this.launchTNT(worldIn, entityIn, new PrimedTnt(worldIn, entityIn.m_20185_(), entityIn.m_20188_(), entityIn.m_20189_(), (LivingEntity)entityIn));
                            break;
                        }
                        case 10: {
                            this.launchTrident(worldIn, entityIn, new ThrownTrident(worldIn, (LivingEntity)entityIn, itemStack));
                        }
                    }
                    if (!entityIn.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                } else if (!itemStack.m_41619_()) {
                    this.launchGenericItem(worldIn, entityIn, new ItemEntity(worldIn, entityIn.m_20185_(), entityIn.m_20188_(), entityIn.m_20189_(), itemStack.m_41620_(1)));
                }
                if (!itemStack.m_41619_()) break;
                entityIn.m_150109_().m_36057_(itemStack);
                break;
            }
        }
        worldIn.m_6263_(entityIn, entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_(), SoundEvents.f_11796_, SoundSource.PLAYERS, 0.75f, 1.0f);
        worldIn.m_6263_(entityIn, entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 0.75f, 1.0f);
        entityIn.m_36335_().m_41524_((Item)this, 10);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player entityIn, InteractionHand handIn) {
        ItemStack item = entityIn.m_21120_(handIn);
        entityIn.m_6672_(handIn);
        return InteractionResultHolder.m_19098_((Object)item);
    }

    private void launchExplosiveProjectile(Level world, Player owner, AbstractHurtingProjectile projectile) {
        projectile.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        projectile.m_5997_(owner.m_20154_().f_82479_, owner.m_20154_().f_82480_, owner.m_20154_().f_82481_);
        if (projectile instanceof WitherSkull) {
            projectile.m_146922_(projectile.m_146908_() % 360.0f - 180.0f);
        }
        world.m_7967_((Entity)projectile);
    }

    private void launchFirework(Level world, Player owner, FireworkRocketEntity firework) {
        firework.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        firework.m_6686_(owner.m_20154_().f_82479_, owner.m_20154_().f_82480_, owner.m_20154_().f_82481_, 1.0f, 0.0f);
        world.m_7967_((Entity)firework);
    }

    private void launchArrow(Level world, Player owner, AbstractArrow arrow) {
        arrow.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        arrow.m_37251_((Entity)owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 4.0f, 1.0f);
        arrow.m_36762_(true);
        if (owner.m_150110_().f_35937_) {
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        world.m_7967_((Entity)arrow);
    }

    private void launchPotion(Level world, Player owner, ItemStack item, ThrownPotion potion) {
        potion.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        potion.m_37446_(item);
        potion.m_37251_((Entity)owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 2.0f, 0.0f);
        world.m_7967_((Entity)potion);
    }

    private void launchEgg(Level world, Player owner, ItemStack item, ThrownEgg egg) {
        egg.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        egg.m_37446_(item);
        egg.m_37251_((Entity)owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 3.5f, 0.0f);
        world.m_7967_((Entity)egg);
    }

    private void launchSnowball(Level world, Player owner, ItemStack item, Snowball snowball) {
        snowball.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        snowball.m_37446_(item);
        snowball.m_37251_((Entity)owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 3.5f, 0.0f);
        world.m_7967_((Entity)snowball);
    }

    private void launchEnderPearl(Level world, Player owner, ItemStack item, ThrownEnderpearl pearl) {
        pearl.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        pearl.m_37446_(item);
        pearl.m_37251_((Entity)owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 4.0f, 0.0f);
        world.m_7967_((Entity)pearl);
    }

    private void launchXPBottle(Level world, Player owner, ItemStack item, ThrownExperienceBottle bottle) {
        bottle.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        bottle.m_37446_(item);
        bottle.m_37251_((Entity)owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 2.0f, 0.0f);
        world.m_7967_((Entity)bottle);
    }

    private void launchTNT(Level world, Player owner, PrimedTnt tnt) {
        tnt.m_5997_(owner.m_20154_().f_82479_ * 2.0, owner.m_20154_().f_82480_ * 2.0, owner.m_20154_().f_82481_ * 2.0);
        world.m_7967_((Entity)tnt);
    }

    private void launchTrident(Level world, Player owner, ThrownTrident trident) {
        trident.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        trident.m_37251_((Entity)owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 4.0f, 0.0f);
        if (owner.m_150110_().f_35937_) {
            trident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        world.m_7967_((Entity)trident);
    }

    private void launchGenericItem(Level world, Player owner, ItemEntity item) {
        item.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        item.m_32052_(owner.m_142081_());
        item.m_5997_(owner.m_20154_().f_82479_ * 2.5, owner.m_20154_().f_82480_ * 2.5, owner.m_20154_().f_82481_ * 2.5);
        item.m_32060_();
        world.m_7967_((Entity)item);
    }

    private static enum CLAZZ {
        ArrowItem,
        ThrowablePotionItem,
        BlockItem;

    }
}

