/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network.client;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkEvent;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.network.NetworkHandler;

public record SetDirectionalPacket(boolean value, BlockPos pos) {
    public static void encode(SetDirectionalPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.value);
        buf.m_130064_(msg.pos);
    }

    public static SetDirectionalPacket decode(FriendlyByteBuf buf) {
        return new SetDirectionalPacket(buf.readBoolean(), buf.m_130135_());
    }

    public static void handle(SetDirectionalPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (NetworkHandler.isBadClientPacket(player, msg.pos)) {
                return;
            }
            ServerLevel world = player.m_183503_();
            BlockState state = world.m_8055_(msg.pos);
            if (state.m_60734_() instanceof ElevatorBlock) {
                world.m_46597_(msg.pos, (BlockState)state.m_61124_((Property)ElevatorBlock.DIRECTIONAL, (Comparable)Boolean.valueOf(msg.value)));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

