/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.SimpleChannel;
import xyz.vsngamer.elevatorid.network.TeleportHandler;
import xyz.vsngamer.elevatorid.network.TeleportRequest;
import xyz.vsngamer.elevatorid.network.client.RemoveCamoPacket;
import xyz.vsngamer.elevatorid.network.client.SetArrowPacket;
import xyz.vsngamer.elevatorid.network.client.SetDirectionalPacket;
import xyz.vsngamer.elevatorid.network.client.SetFacingPacket;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;

public class NetworkHandler {
    private static final int PROTOCOL_VERSION = 1;
    public static SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)new ResourceLocation("elevatorid", "main_channel")).acceptedVersions(Channel.VersionTest.exact((int)1)).networkProtocolVersion(1).simpleChannel();

    public static void init() {
        INSTANCE.messageBuilder(TeleportRequest.class, NetworkDirection.PLAY_TO_SERVER).encoder(TeleportRequest::encode).decoder(TeleportRequest::decode).consumerMainThread(TeleportHandler::handle).add();
        INSTANCE.messageBuilder(SetDirectionalPacket.class, NetworkDirection.PLAY_TO_SERVER).encoder(SetDirectionalPacket::encode).decoder(SetDirectionalPacket::decode).consumerMainThread(SetDirectionalPacket::handle).add();
        INSTANCE.messageBuilder(SetArrowPacket.class, NetworkDirection.PLAY_TO_SERVER).encoder(SetArrowPacket::encode).decoder(SetArrowPacket::decode).consumerMainThread(SetArrowPacket::handle).add();
        INSTANCE.messageBuilder(RemoveCamoPacket.class, NetworkDirection.PLAY_TO_SERVER).encoder(RemoveCamoPacket::encode).decoder(RemoveCamoPacket::decode).consumerMainThread(RemoveCamoPacket::handle).add();
        INSTANCE.messageBuilder(SetFacingPacket.class, NetworkDirection.PLAY_TO_SERVER).encoder(SetFacingPacket::encode).decoder(SetFacingPacket::decode).consumerMainThread(SetFacingPacket::handle).add();
    }

    public static boolean isBadClientPacket(ServerPlayer player, BlockPos pos) {
        if (player == null || player.m_21224_() || player.m_213877_()) {
            return true;
        }
        Level world = player.m_9236_();
        if (!world.m_46749_(pos)) {
            return true;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof ElevatorContainer)) {
            return true;
        }
        ElevatorContainer container = (ElevatorContainer)abstractContainerMenu;
        return !container.getPos().equals((Object)pos);
    }
}

