/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network.client;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.network.CustomPayloadEvent;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.network.NetworkHandler;

public record SetFacingPacket(Direction direction, BlockPos pos) {
    public static void encode(SetFacingPacket msg, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)msg.direction);
        buf.m_130064_(msg.pos);
    }

    public static SetFacingPacket decode(FriendlyByteBuf buf) {
        return new SetFacingPacket((Direction)buf.m_130066_(Direction.class), buf.m_130135_());
    }

    public static void handle(SetFacingPacket msg, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (NetworkHandler.isBadClientPacket(player, msg.pos)) {
                return;
            }
            Level world = player.m_9236_();
            BlockState state = world.m_8055_(msg.pos);
            if (state.m_60734_() instanceof ElevatorBlock) {
                world.m_46597_(msg.pos, (BlockState)state.m_61124_((Property)ElevatorBlock.f_54117_, (Comparable)msg.direction));
            }
        });
        ctx.setPacketHandled(true);
    }
}

