/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelDataManager;
import xyz.vsngamer.elevatorid.client.render.ElevatorBakedModel;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;
import xyz.vsngamer.elevatorid.util.FakeUseContext;

public class ElevatorBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty DIRECTIONAL = BooleanProperty.create((String)"directional");
    public static final BooleanProperty SHOW_ARROW = BooleanProperty.create((String)"show_arrow");
    private static final MapCodec<ElevatorBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(ElevatorBlock::getColor)).apply((Applicative)instance, ElevatorBlock::new));
    private final DyeColor dyeColor;

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public ElevatorBlock(DyeColor color) {
        super(BlockBehaviour.Properties.of().mapColor(color).sound(SoundType.WOOL).strength(0.8f).dynamicShape().noOcclusion().forceSolidOn());
        this.dyeColor = color;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, DIRECTIONAL, SHOW_ARROW});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)DIRECTIONAL, (Comparable)Boolean.valueOf(false))).setValue((Property)SHOW_ARROW, (Comparable)Boolean.valueOf(true));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ElevatorTileEntity(pos, state);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public InteractionResult use(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        return this.getElevatorTile((BlockGetter)worldIn, pos).map(tile -> {
            Block handBlock = Block.byItem((Item)player.getItemInHand(handIn).getItem());
            BlockState stateToApply = handBlock.getStateForPlacement((BlockPlaceContext)new FakeUseContext(player, handIn, hit));
            if (stateToApply != null && tile.setCamoAndUpdate(stateToApply)) {
                return InteractionResult.SUCCESS;
            }
            if (player.isCrouching() && tile.getHeldState() != null) {
                tile.setCamoAndUpdate(null);
                return InteractionResult.SUCCESS;
            }
            player.openMenu((MenuProvider)tile, pos);
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.FAIL);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return (Boolean)ModConfig.GENERAL.mobSpawn.get() != false && super.isValidSpawn(state, world, pos, type, entityType);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getHeldState(worldIn, pos).map(s -> s.getCollisionShape(worldIn, pos, context)).orElse(super.getCollisionShape(state, worldIn, pos, context));
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity collidingEntity) {
        return this.getHeldState(world, pos).map(s -> s.collisionExtendsVertically(world, pos, collidingEntity)).orElse(super.collisionExtendsVertically(state, world, pos, collidingEntity));
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return this.getHeldState(world, pos).map(s -> s.isCollisionShapeFullBlock(world, pos)).orElse(super.isCollisionShapeFullBlock(state, world, pos));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getHeldState(worldIn, pos).map(s -> s.getShape(worldIn, pos, context)).orElse(super.getShape(state, worldIn, pos, context));
    }

    public float getFriction(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getHeldState((BlockGetter)world, pos).map(s -> Float.valueOf(s.getFriction(world, pos, entity))).orElse(Float.valueOf(super.getFriction(state, world, pos, entity))).floatValue();
    }

    public float getSpeedFactor() {
        return super.getSpeedFactor();
    }

    public float getJumpFactor() {
        return super.getJumpFactor();
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!worldIn.isClientSide()) {
            this.getElevatorTile((BlockGetter)worldIn, currentPos).ifPresent(t -> {
                if (t.getHeldState() == null) {
                    return;
                }
                BlockState appearance = facingState.getAppearance((BlockAndTintGetter)worldIn, facingPos, facing.getOpposite(), t.getHeldState(), currentPos);
                BlockState updatedState = t.getHeldState().updateShape(facing, appearance, worldIn, currentPos, facingPos);
                if (updatedState != t.getHeldState()) {
                    t.setHeldState(updatedState);
                    t.setChanged();
                }
            });
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return this.getHeldState(world, pos).map(s -> s.getBlock().canConnectRedstone(s, world, pos, side)).orElse(super.canConnectRedstone(state, world, pos, side));
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return this.getHeldState((BlockGetter)level, pos).map(s -> s.shouldCheckWeakPower(level, pos, side)).orElse(super.shouldCheckWeakPower(state, level, pos, side));
    }

    public int getSignal(BlockState state, BlockGetter reader, BlockPos pos, Direction direction) {
        return this.getHeldState(reader, pos).map(s -> s.getSignal(reader, pos, direction)).orElse(super.getSignal(state, reader, pos, direction));
    }

    public int getDirectSignal(BlockState state, BlockGetter reader, BlockPos pos, Direction direction) {
        return this.getHeldState(reader, pos).map(s -> s.getDirectSignal(reader, pos, direction)).orElse(super.getDirectSignal(state, reader, pos, direction));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return Optional.ofNullable(world.getAuxLightManager(pos)).map(lm -> lm.getLightAt(pos)).orElse(0);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.getHeldState(worldIn, pos).map(s -> s.getLightBlock(worldIn, pos)).orElse(worldIn.getMaxLightLevel());
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return this.getHeldState(world, pos).map(s -> s.getOcclusionShape(world, pos)).orElse(super.getOcclusionShape(state, world, pos));
    }

    public boolean skipRendering(BlockState state, BlockState otherState, Direction side) {
        return super.skipRendering(state, otherState, side);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        ModelDataManager modelManager = level.getModelDataManager();
        if (modelManager == null) {
            return super.hidesNeighborFace(level, pos, state, neighborState, dir);
        }
        ModelData modelData = modelManager.getAt(pos);
        if (modelData == null) {
            return super.hidesNeighborFace(level, pos, state, neighborState, dir);
        }
        BlockState heldState = (BlockState)modelData.get(ElevatorBakedModel.HELD_STATE);
        if (heldState == null) {
            return super.hidesNeighborFace(level, pos, state, neighborState, dir);
        }
        ModelData neighborModelData = modelManager.getAt(pos.relative(dir));
        if (neighborModelData == null) {
            return heldState.skipRendering(neighborState, dir);
        }
        BlockState neighborHeldState = (BlockState)neighborModelData.get(ElevatorBakedModel.HELD_STATE);
        return heldState.skipRendering(Objects.requireNonNullElse(neighborHeldState, neighborState), dir);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return this.getHeldState((BlockGetter)level, pos).orElse(super.getAppearance(state, level, pos, side, queryState, queryPos));
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.getHeldState((BlockGetter)world, pos).map(s -> s.getSoundType(world, pos, entity)).orElse(super.getSoundType(state, world, pos, entity));
    }

    public DyeColor getColor() {
        return this.dyeColor;
    }

    private Optional<ElevatorTileEntity> getElevatorTile(BlockGetter world, BlockPos pos) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        return world.getBlockEntity(pos, Registry.ELEVATOR_TILE_ENTITY.get());
    }

    private Optional<BlockState> getHeldState(BlockGetter world, BlockPos pos) {
        return this.getElevatorTile(world, pos).map(ElevatorTileEntity::getHeldState);
    }
}

