/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

public class TeleportHandler {
    private static final TeleportHandler INSTANCE = new TeleportHandler();

    public static TeleportHandler getInstance() {
        return INSTANCE;
    }

    void handle(TeleportRequest message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            double toZ;
            double toX;
            float pitch;
            Level patt1883$temp;
            Player player = ctx.player().orElse(null);
            if (TeleportHandler.isBadTeleportPacket(message, player)) {
                return;
            }
            if (((Boolean)ModConfig.GENERAL.useXP.get()).booleanValue() && !player.isCreative()) {
                Integer xpCost = (Integer)ModConfig.GENERAL.XPPointsAmount.get();
                if (TeleportHandler.getPlayerExperienceProgress(player) - xpCost >= 0 || player.experienceLevel > 0) {
                    player.giveExperiencePoints(-xpCost.intValue());
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"elevatorid.message.missing_xp").withStyle(ChatFormatting.RED), true);
                    return;
                }
            }
            if (!((patt1883$temp = player.level()) instanceof ServerLevel)) {
                return;
            }
            ServerLevel world = (ServerLevel)patt1883$temp;
            BlockPos toPos = message.to();
            BlockState toState = world.getBlockState(message.to());
            float yaw = (Boolean)toState.getValue((Property)ElevatorBlock.DIRECTIONAL) != false ? ((Direction)toState.getValue((Property)ElevatorBlock.FACING)).toYRot() : player.getYRot();
            float f = pitch = (Boolean)toState.getValue((Property)ElevatorBlock.DIRECTIONAL) != false && (Boolean)ModConfig.GENERAL.resetPitchDirectional.get() != false || (Boolean)toState.getValue((Property)ElevatorBlock.DIRECTIONAL) == false && (Boolean)ModConfig.GENERAL.resetPitchNormal.get() != false ? 0.0f : player.getXRot();
            if (((Boolean)ModConfig.GENERAL.precisionTarget.get()).booleanValue()) {
                toX = (double)toPos.getX() + 0.5;
                toZ = (double)toPos.getZ() + 0.5;
            } else {
                toX = player.getX();
                toZ = player.getZ();
            }
            double blockYOffset = toState.getBlockSupportShape((BlockGetter)world, toPos).max(Direction.Axis.Y);
            player.teleportTo(world, toX, Math.max((double)toPos.getY(), (double)toPos.getY() + blockYOffset), toZ, EnumSet.noneOf(RelativeMovement.class), yaw, pitch);
            player.setDeltaMovement(player.getDeltaMovement().multiply(new Vec3(1.0, 0.0, 1.0)));
            world.playSound(null, toPos, Registry.TELEPORT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }

    private static boolean isBadTeleportPacket(TeleportRequest msg, Player player) {
        if (player == null || !player.isAlive()) {
            return true;
        }
        Level world = player.level();
        BlockPos fromPos = msg.from();
        BlockPos toPos = msg.to();
        if (!world.isLoaded(fromPos) || !world.isLoaded(toPos)) {
            return true;
        }
        double distanceSq = player.distanceToSqr(Vec3.atCenterOf((Vec3i)fromPos));
        if (distanceSq > 6.0) {
            return true;
        }
        if (fromPos.getX() != toPos.getX() || fromPos.getZ() != toPos.getZ()) {
            return true;
        }
        if (fromPos.getY() == toPos.getY()) {
            return true;
        }
        ElevatorBlock fromElevator = TeleportHandler.getElevator(world.getBlockState(fromPos));
        ElevatorBlock toElevator = TeleportHandler.getElevator(world.getBlockState(toPos));
        if (fromElevator == null || toElevator == null) {
            return true;
        }
        if (!TeleportHandler.isValidPos((BlockGetter)world, toPos)) {
            return true;
        }
        return (Boolean)ModConfig.GENERAL.sameColor.get() != false && fromElevator.getColor() != toElevator.getColor();
    }

    private static int getPlayerExperienceProgress(Player player) {
        return Math.round(player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static boolean isValidPos(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.above()).getCollisionShape(world, pos.above()).isEmpty();
    }

    public static ElevatorBlock getElevator(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof ElevatorBlock) {
            ElevatorBlock elevator = (ElevatorBlock)block;
            return elevator;
        }
        return null;
    }
}

