/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network.client;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;
import xyz.vsngamer.elevatorid.network.NetworkHandler;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;

public record RemoveCamoPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("elevatorid", "remove_camo");

    public RemoveCamoPacket(FriendlyByteBuf buf) {
        this(buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    public static class Handler {
        private static final Handler INSTANCE = new Handler();

        public static Handler getInstance() {
            return INSTANCE;
        }

        public void handle(RemoveCamoPacket msg, PlayPayloadContext ctx) {
            ctx.workHandler().submitAsync(() -> {
                Player player = ctx.player().orElse(null);
                if (NetworkHandler.isBadClientPacket(player, msg.pos)) {
                    return;
                }
                BlockEntity patt1576$temp = player.level().getBlockEntity(msg.pos);
                if (patt1576$temp instanceof ElevatorTileEntity) {
                    ElevatorTileEntity tile = (ElevatorTileEntity)patt1576$temp;
                    tile.setCamoAndUpdate(null);
                }
            });
        }
    }
}

