/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.tile;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.client.render.ElevatorBakedModel;
import xyz.vsngamer.elevatorid.init.Registry;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;

public class ElevatorTileEntity
extends BlockEntity
implements MenuProvider {
    private BlockState heldState;

    public ElevatorTileEntity(BlockPos pos, BlockState state) {
        super(Registry.ELEVATOR_TILE_ENTITY.get(), pos, state);
    }

    public void load(@Nonnull CompoundTag tag) {
        super.load(tag);
        if (tag.contains("held_id")) {
            BlockState state = NbtUtils.readBlockState((HolderGetter)(this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup()), (CompoundTag)tag.getCompound("held_id"));
            this.heldState = ElevatorTileEntity.isValidState(state) ? state : null;
        } else {
            this.heldState = null;
        }
    }

    protected void saveAdditional(@Nonnull CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.heldState != null) {
            tag.put("held_id", (Tag)NbtUtils.writeBlockState((BlockState)this.heldState));
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ElevatorBakedModel.HELD_STATE, (Object)this.heldState).build();
    }

    @Nonnull
    public CompoundTag getUpdateTag() {
        return this.saveWithId();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.markUpdated();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.getTag());
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)"screen.elevatorid.elevator");
    }

    public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new ElevatorContainer(id, this.worldPosition, player);
    }

    public void setHeldState(BlockState state) {
        this.heldState = state;
        this.markUpdated();
    }

    private void markUpdated() {
        this.setChanged();
        this.requestModelDataUpdate();
        if (this.level == null) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.getBlockState().updateNeighbourShapes((LevelAccessor)this.level, this.worldPosition, 2);
        Optional.ofNullable(this.level.getAuxLightManager(this.worldPosition)).ifPresent(lm -> lm.setLightAt(this.worldPosition, Optional.ofNullable(this.heldState).map(b -> b.getLightEmission((BlockGetter)this.level, this.worldPosition)).orElse(0).intValue()));
        this.level.getLightEngine().checkBlock(this.worldPosition);
    }

    public BlockState getHeldState() {
        return this.heldState;
    }

    public boolean setCamoAndUpdate(BlockState newState) {
        if (this.heldState == newState) {
            return false;
        }
        if (!ElevatorTileEntity.isValidState(newState)) {
            return false;
        }
        this.setHeldState(newState);
        if (this.getLevel() != null) {
            this.getLevel().playSound(null, this.getBlockPos(), Registry.CAMOUFLAGE_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public static boolean isValidState(BlockState state) {
        if (state == null) {
            return true;
        }
        if (state.getBlock() == Blocks.AIR) {
            return false;
        }
        if (state.getBlock() instanceof ElevatorBlock) {
            return false;
        }
        if (state.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        return !state.getCollisionShape(null, null).isEmpty();
    }
}

