/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.client;

import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.client.gui.ElevatorScreen;
import xyz.vsngamer.elevatorid.client.render.ColorCamoElevator;
import xyz.vsngamer.elevatorid.client.render.ElevatorBakedModel;
import xyz.vsngamer.elevatorid.init.Registry;

@EventBusSubscriber(modid="elevatorid", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientRegistry {
    @SubscribeEvent
    public static void onMenuScreensRegistry(RegisterMenuScreensEvent e) {
        e.register(Registry.ELEVATOR_CONTAINER.get(), ElevatorScreen::new);
    }

    @SubscribeEvent
    public static void onBlockColorHandlersRegistry(RegisterColorHandlersEvent.Block e) {
        e.register((BlockColor)new ColorCamoElevator(), (Block[])Registry.ELEVATOR_BLOCKS.values().stream().map(DeferredHolder::get).toArray(ElevatorBlock[]::new));
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelEvent.RegisterAdditional e) {
        e.register(new ResourceLocation("elevatorid", "arrow"));
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult e) {
        e.getModels().entrySet().stream().filter(entry -> "elevatorid".equals(((ResourceLocation)entry.getKey()).getNamespace()) && ((ResourceLocation)entry.getKey()).getPath().contains("elevator_")).forEach(entry -> e.getModels().put((ResourceLocation)entry.getKey(), new ElevatorBakedModel((BakedModel)entry.getValue())));
    }
}

