/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.network.NetworkHandler;

public record SetArrowPacket(boolean value, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetArrowPacket> TYPE = new CustomPacketPayload.Type(new ResourceLocation("elevatorid", "set_arrow"));
    public static final StreamCodec<ByteBuf, SetArrowPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SetArrowPacket::value, (StreamCodec)BlockPos.STREAM_CODEC, SetArrowPacket::pos, SetArrowPacket::new);

    public CustomPacketPayload.Type<SetArrowPacket> type() {
        return TYPE;
    }

    public static void handle(SetArrowPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (NetworkHandler.isBadClientPacket((Player)player, msg.pos)) {
                return;
            }
            Level world = player.level();
            BlockState state = world.getBlockState(msg.pos);
            if (state.getBlock() instanceof ElevatorBlock) {
                world.setBlockAndUpdate(msg.pos, (BlockState)state.setValue((Property)ElevatorBlock.SHOW_ARROW, (Comparable)Boolean.valueOf(msg.value)));
            }
        });
    }
}

