/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.client.gui.FacingButton;
import xyz.vsngamer.elevatorid.client.gui.FacingControllerWrapper;
import xyz.vsngamer.elevatorid.network.client.RemoveCamoPacket;
import xyz.vsngamer.elevatorid.network.client.SetArrowPacket;
import xyz.vsngamer.elevatorid.network.client.SetDirectionalPacket;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;

public class ElevatorScreen
extends AbstractContainerScreen<ElevatorContainer> {
    private final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"textures/gui/elevator_gui.png");
    private final ElevatorTileEntity tile;
    private final Direction playerFacing;
    private Checkbox dirButton;
    private Checkbox hideArrowButton;
    private Button resetCamoButton;
    private FacingControllerWrapper facingController;

    public ElevatorScreen(ElevatorContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.imageWidth = 200;
        this.imageHeight = 100;
        this.tile = container.getTile();
        this.playerFacing = container.getPlayerFacing();
    }

    public void init() {
        super.init();
        MutableComponent dirLang = Component.translatable((String)"screen.elevatorid.elevator.directional");
        this.dirButton = Checkbox.builder((Component)dirLang, (Font)this.font).pos(this.leftPos + 8, this.topPos + 25).selected(((Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.DIRECTIONAL)).booleanValue()).onValueChange((checkbox, selected) -> PacketDistributor.sendToServer((CustomPacketPayload)new SetDirectionalPacket(selected, this.tile.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
        this.addRenderableWidget((GuiEventListener)this.dirButton);
        MutableComponent arrowLang = Component.translatable((String)"screen.elevatorid.elevator.hide_arrow");
        this.hideArrowButton = Checkbox.builder((Component)arrowLang, (Font)this.font).pos(this.leftPos + 8, this.topPos + 50).selected((Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.SHOW_ARROW) == false).onValueChange((checkbox, selected) -> PacketDistributor.sendToServer((CustomPacketPayload)new SetArrowPacket(!selected, this.tile.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])).build();
        this.hideArrowButton.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.DIRECTIONAL);
        this.addRenderableWidget((GuiEventListener)this.hideArrowButton);
        MutableComponent resetCamoLang = Component.translatable((String)"screen.elevatorid.elevator.reset_camo");
        this.resetCamoButton = Button.builder((Component)resetCamoLang, but -> PacketDistributor.sendToServer((CustomPacketPayload)new RemoveCamoPacket(this.tile.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])).pos(this.leftPos + 8, this.topPos + 75).size(110, 20).build();
        this.addRenderableWidget((GuiEventListener)this.resetCamoButton);
        this.facingController = new FacingControllerWrapper(this.leftPos + 120, this.topPos + 20, this.tile.getBlockPos(), this.playerFacing);
        this.facingController.getButtons().forEach(x$0 -> {
            FacingButton cfr_ignored_0 = (FacingButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.facingController.getButtons().forEach(button -> {
            button.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.DIRECTIONAL);
            button.active = this.tile.getBlockState().getValue((Property)ElevatorBlock.FACING) != button.direction;
        });
        this.resetCamoButton.active = this.tile.getHeldState() != null;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void containerTick() {
        super.containerTick();
        this.dirButton.selected = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.DIRECTIONAL);
        this.facingController.getButtons().forEach(button -> {
            button.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.DIRECTIONAL);
            button.active = this.tile.getBlockState().getValue((Property)ElevatorBlock.FACING) != button.direction;
        });
        this.hideArrowButton.visible = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.DIRECTIONAL);
        this.hideArrowButton.selected = (Boolean)this.tile.getBlockState().getValue((Property)ElevatorBlock.SHOW_ARROW) == false;
        this.resetCamoButton.active = this.tile.getHeldState() != null;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float v, int mouseX, int mouseY) {
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.GUI_TEXTURE, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 8, 0xE0E0E0);
    }
}

