/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xyz.vsngamer.elevatorid.network.NetworkHandler;
import xyz.vsngamer.elevatorid.tile.ElevatorTileEntity;

public record RemoveCamoPacket(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoveCamoPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"remove_camo"));
    public static final StreamCodec<ByteBuf, RemoveCamoPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RemoveCamoPacket::pos, RemoveCamoPacket::new);

    public CustomPacketPayload.Type<RemoveCamoPacket> type() {
        return TYPE;
    }

    public static void handle(RemoveCamoPacket msg, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)ctx.player();
            if (NetworkHandler.isBadClientPacket((Player)player, msg.pos)) {
                return;
            }
            BlockEntity patt0$temp = player.level().getBlockEntity(msg.pos);
            if (patt0$temp instanceof ElevatorTileEntity) {
                ElevatorTileEntity tile = (ElevatorTileEntity)patt0$temp;
                tile.setCamoAndUpdate(null);
            }
        });
    }
}

