/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.quarris.enigmaticgraves.command.GraveEntryType;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import java.util.LinkedList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;

public class RestoreGraveCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_ENTRIES = (ctx, builder) -> {
        try {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((IWorld)player.field_70170_p).getGraveEntriesForPlayer(player.func_110124_au());
            if (entries == null) {
                return Suggestions.empty();
            }
            for (int i = 0; i < entries.size(); ++i) {
                PlayerGraveEntry entry = entries.get(i);
                builder.suggest(entry.getEntryName(i));
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return builder.buildFuture();
    };
    private static final ITextComponent GRAVE_ALREADY_RESTORED = new StringTextComponent("Warning: That grave has already been restored. Add 'true' at the end of the last command to restore again.");
    private static final ITextComponent SUCCESSFULLY_RESTORED = new StringTextComponent("Successfully restored the grave.");
    private static final ITextComponent HELP = new StringTextComponent(TextFormatting.RED + "Usage:\n/enigmatic_graves <player> list\n/enigmatic_graves <player> clear\n/enigmatic_graves <player> restore [death_<id> [forced]]");

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"enigmatic_graves").requires(source -> source.func_197034_c(2))).executes(ctx -> {
            ((CommandSource)ctx.getSource()).func_197030_a(HELP, false);
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"list").executes(ctx -> {
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)ctx, (String)"target");
            LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((IWorld)((CommandSource)ctx.getSource()).func_197023_e()).getGraveEntriesForPlayer(player.func_110124_au());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < entries.size(); ++i) {
                sb.append(((PlayerGraveEntry)entries.get(i)).getEntryName(i));
                if (i >= entries.size() - 1) continue;
                sb.append('\n');
            }
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(sb.toString()), false);
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"restore").executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSource>)ctx, false, false))).then(Commands.func_197056_a((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSource>)ctx, false, BoolArgumentType.getBool((CommandContext)ctx, (String)"forced"))))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"entry", (ArgumentType)new GraveEntryType()).suggests(SUGGEST_ENTRIES).executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSource>)ctx, true, false))).then(Commands.func_197056_a((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RestoreGraveCommand.restoreGrave((CommandContext<CommandSource>)ctx, true, BoolArgumentType.getBool((CommandContext)ctx, (String)"forced"))))))).then(Commands.func_197057_a((String)"clear").executes(ctx -> {
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)ctx, (String)"target");
            GraveManager.getWorldGraveData((IWorld)player.field_70170_p).clearGraveEntries((PlayerEntity)player);
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"graves").executes(ctx -> {
            ((CommandSource)ctx.getSource()).func_197030_a(HELP, false);
            return 0;
        })).redirect((CommandNode)cmd));
    }

    private static int restoreGrave(CommandContext<CommandSource> ctx, boolean useArg, boolean forced) throws CommandSyntaxException {
        ServerPlayerEntity player;
        PlayerGraveEntry entry = useArg ? GraveEntryType.getEntry(player.func_110124_au(), ctx, "entry") : GraveManager.getWorldGraveData((IWorld)((CommandSource)ctx.getSource()).func_197023_e()).getGraveEntriesForPlayer(player.func_110124_au()).getFirst();
        if (!RestoreGraveCommand.tryRestoreGrave(entry, (PlayerEntity)(player = EntityArgument.func_197089_d(ctx, (String)"target")), forced)) {
            ((CommandSource)ctx.getSource()).func_197030_a(GRAVE_ALREADY_RESTORED, true);
            return 1;
        }
        ((CommandSource)ctx.getSource()).func_197030_a(SUCCESSFULLY_RESTORED, true);
        return 0;
    }

    private static boolean tryRestoreGrave(PlayerGraveEntry graveEntry, PlayerEntity player, boolean forced) {
        if (!forced && graveEntry.isRestored()) {
            return false;
        }
        for (IGraveData graveData : graveEntry.dataList) {
            graveData.restore(player);
        }
        if (!graveEntry.isRestored()) {
            GraveManager.getWorldGraveData((IWorld)player.field_70170_p).setGraveRestored(graveEntry.graveUUID);
        }
        return true;
    }
}

