/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.compat;

import dev.quarris.enigmaticgraves.grave.data.CurioGraveData;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.common.capability.CurioInventoryCapability;

public class CurioCompat {
    public static final Map<UUID, ICuriosItemHandler> CACHED_CURIOS = new HashMap<UUID, ICuriosItemHandler>();
    private static final Constructor<CurioInventoryCapability.CurioInventoryWrapper> CURIO_CTOR = ObfuscationReflectionHelper.findConstructor(CurioInventoryCapability.CurioInventoryWrapper.class, (Class[])new Class[]{PlayerEntity.class});

    public static void cacheCurios(PlayerEntity player) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            try {
                ICuriosItemHandler cached = CurioCompat.createCurioItemHandler(player);
                CuriosCapability.INVENTORY.readNBT((Object)cached, null, CuriosCapability.INVENTORY.writeNBT(handler, null));
                CACHED_CURIOS.put(player.func_110124_au(), cached);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static IGraveData generateCurioGraveData(PlayerEntity player, Collection<ItemStack> drops) {
        if (CACHED_CURIOS.containsKey(player.func_110124_au())) {
            CurioGraveData data = new CurioGraveData(CACHED_CURIOS.get(player.func_110124_au()), drops);
            CACHED_CURIOS.remove(player.func_110124_au());
            return data;
        }
        return null;
    }

    public static ICuriosItemHandler createCurioItemHandler(PlayerEntity player) {
        try {
            return (ICuriosItemHandler)CURIO_CTOR.newInstance(player);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

