/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.content;

import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.setup.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class GraveEntity
extends Entity {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(GraveEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private List<IGraveData> contents = new ArrayList<IGraveData>();

    public static GraveEntity createGrave(PlayerEntity player, List<IGraveData> graveData) {
        GraveEntity grave = new GraveEntity(player);
        BlockPos.Mutable spawnPos = new BlockPos.Mutable();
        boolean spawnBlockBelow = GraveManager.getSpawnPosition(player.field_70170_p, player.func_213303_ch(), spawnPos);
        if (spawnBlockBelow) {
            ResourceLocation blockName = new ResourceLocation((String)GraveConfigs.COMMON.graveFloorBlock.get());
            BlockState state = ((Block)ForgeRegistries.BLOCKS.getValue(blockName)).func_176223_P();
            player.field_70170_p.func_180501_a(spawnPos.func_177977_b(), state, 3);
            player.field_70170_p.func_217379_c(2001, (BlockPos)spawnPos, Block.func_196246_j((BlockState)state));
        }
        grave.func_70101_b(player.field_70177_z, 0.0f);
        grave.func_70634_a((float)spawnPos.func_177958_n() + player.func_213311_cf() / 2.0f, spawnPos.func_177956_o(), (float)spawnPos.func_177952_p() + player.func_213311_cf() / 2.0f);
        grave.setContents(graveData);
        return grave;
    }

    public GraveEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public GraveEntity(PlayerEntity player) {
        this((EntityType)Registry.GRAVE_ENTITY_TYPE.get(), player.field_70170_p);
        this.setOwner(player.func_110124_au());
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && GraveManager.getWorldGraveData((IWorld)this.field_70170_p).isGraveRestored(this.func_110124_au())) {
            this.func_70106_y();
            GraveManager.getWorldGraveData((IWorld)this.field_70170_p).removeGraveRestored(this.func_110124_au());
        }
        super.func_70071_h_();
    }

    public boolean func_225510_bt_() {
        if (this.field_70170_p.field_72995_K && this.getOwner() != null && this.getOwnerUUID().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            PlayerEntity player = this.getOwner();
            ItemStack stack = null;
            if (player.func_184614_ca().func_77973_b() == Registry.GRAVE_FINDER_ITEM.get()) {
                stack = player.func_184614_ca();
            }
            if (stack == null && player.func_184592_cb().func_77973_b() != Registry.GRAVE_FINDER_ITEM.get()) {
                stack = player.func_184592_cb();
            }
            if (stack == null) {
                return false;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("GraveUUID")) {
                return false;
            }
            UUID graveUUID = stack.func_77978_p().func_186857_a("GraveUUID");
            if (this.func_110124_au().equals(graveUUID)) {
                return true;
            }
        }
        return super.func_225510_bt_();
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.empty());
    }

    public void func_70100_b_(PlayerEntity player) {
        if (player.func_225608_bj_() && this.belongsTo(player)) {
            this.restoreGrave(player);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.belongsTo(player)) {
            this.restoreGrave(player);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private void restoreGrave(PlayerEntity player) {
        if (!this.func_70089_S() || this.field_70170_p.field_72995_K) {
            return;
        }
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            CompoundNBT nbt;
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            if (stack.func_77973_b() != Registry.GRAVE_FINDER_ITEM.get() || !stack.func_77942_o() || (nbt = stack.func_77978_p()) == null || !nbt.func_74764_b("GraveUUID") || !nbt.func_186857_a("GraveUUID").equals(this.func_110124_au())) continue;
            player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
            break;
        }
        for (IGraveData data : this.contents) {
            data.restore(player);
        }
        GraveManager.setGraveRestored(this.getOwnerUUID(), this);
        this.func_70106_y();
    }

    private boolean belongsTo(PlayerEntity player) {
        return player.func_110124_au().equals(this.getOwnerUUID());
    }

    protected void func_213281_b(CompoundNBT compound) {
        CompoundNBT graveNBT = new CompoundNBT();
        ListNBT contentNBT = new ListNBT();
        for (IGraveData data : this.contents) {
            contentNBT.add((Object)data.serializeNBT());
        }
        graveNBT.func_218657_a("Content", (INBT)contentNBT);
        if (this.getOwnerUUID() != null) {
            graveNBT.func_186854_a("Owner", this.getOwnerUUID());
        }
        compound.func_218657_a("Grave", (INBT)graveNBT);
    }

    protected void func_70037_a(CompoundNBT compound) {
        CompoundNBT graveNBT = compound.func_74775_l("Grave");
        ArrayList<IGraveData> dataList = new ArrayList<IGraveData>();
        ListNBT contentNBT = graveNBT.func_150295_c("Content", 10);
        for (INBT inbt : contentNBT) {
            CompoundNBT dataNBT = (CompoundNBT)inbt;
            ResourceLocation name = new ResourceLocation(dataNBT.func_74779_i("Name"));
            IGraveData data = GraveManager.GRAVE_DATA_SUPPLIERS.get(name).apply(dataNBT);
            dataList.add(data);
        }
        this.setContents(dataList);
        if (graveNBT.func_74764_b("Owner")) {
            this.field_70180_af.func_187227_b(OWNER, Optional.of(graveNBT.func_186857_a("Owner")));
        }
    }

    public void setContents(List<IGraveData> contents) {
        this.contents = contents;
    }

    public void setOwner(UUID ownerUUID) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(ownerUUID));
    }

    @Nullable
    public PlayerEntity getOwner() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER)).map(arg_0 -> ((World)this.field_70170_p).func_217371_b(arg_0)).orElse(null);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER)).orElse(null);
    }

    public boolean func_70067_L() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

